/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.WhenScalar;

public class SimpleCase
extends Val {
    private static final long serialVersionUID = 1L;
    private final Val _caseOperand;
    private final Exp[] _exp;
    private final Val _val;

    SimpleCase(Val caseOperand, Exp[] exp, Val val) {
        this._caseOperand = caseOperand;
        this._exp = exp;
        this._val = val;
    }

    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object o1 = this._caseOperand.eval(candidate, orig, ctx, params);
        for (Exp exp : this._exp) {
            Object o2 = ((WhenScalar)exp).getVal1().eval(candidate, orig, ctx, params);
            if (o1 != null && o2 != null) {
                Class<?> c = Filters.promote(o1.getClass(), o2.getClass());
                o1 = Filters.convert(o1, c);
                o2 = Filters.convert(o2, c);
            }
            if (!this.compare(o1, o2)) continue;
            return ((WhenScalar)exp).getVal2().eval(candidate, orig, ctx, params);
        }
        return this._val.eval(candidate, orig, ctx, params);
    }

    protected Object eval(Object candidate, StoreContext ctx, Object[] params) {
        Object o1 = this._caseOperand.eval(candidate, null, ctx, params);
        for (Exp exp : this._exp) {
            Object o2 = ((WhenScalar)exp).getVal1().eval(candidate, null, ctx, params);
            if (o1 != null && o2 != null) {
                Class<?> c = Filters.promote(o1.getClass(), o2.getClass());
                o1 = Filters.convert(o1, c);
                o2 = Filters.convert(o2, c);
            }
            if (!this.compare(o1, o2)) continue;
            return ((WhenScalar)exp).getVal2().eval(candidate, null, ctx, params);
        }
        return this._val.eval(candidate, null, ctx, params);
    }

    protected boolean compare(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    @Override
    public Class getType() {
        Class<?> c1 = this._val.getType();
        for (Exp exp : this._exp) {
            Class c2 = ((WhenScalar)exp).getVal1().getType();
            c1 = Filters.promote(c1, c2);
        }
        return c1;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._caseOperand.acceptVisit(visitor);
        for (Exp exp : this._exp) {
            exp.acceptVisit(visitor);
        }
        this._val.acceptVisit(visitor);
        visitor.exit(this);
    }
}

