/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.api;

import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.core.MailAddress;

public interface BlobExportMechanism {
    public ShareeStage blobId(BlobId var1);

    @FunctionalInterface
    public static interface FinalStage {
        public void export() throws BlobExportException;
    }

    @FunctionalInterface
    public static interface FileExtensionStage {
        public FinalStage fileExtension(Optional<FileExtension> var1);

        default public FinalStage noFileExtension() {
            return this.fileExtension(Optional.empty());
        }

        default public FinalStage fileExtension(FileExtension extension) {
            return this.fileExtension(Optional.of(extension));
        }
    }

    @FunctionalInterface
    public static interface FilePrefixStage {
        public FileExtensionStage filePrefix(Optional<String> var1);

        default public FileExtensionStage noFileCustomPrefix() {
            return this.filePrefix(Optional.empty());
        }

        default public FileExtensionStage filePrefix(String prefix) {
            return this.filePrefix(Optional.of(prefix));
        }
    }

    @FunctionalInterface
    public static interface ExplanationStage {
        public FilePrefixStage explanation(String var1);
    }

    @FunctionalInterface
    public static interface ShareeStage {
        public ExplanationStage with(MailAddress var1);
    }

    public static class BlobExportException
    extends RuntimeException {
        public BlobExportException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

