/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.util.Arrays;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQJMSClientBundle_impl
implements ActiveMQJMSClientBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJMSClientBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQInvalidFilterExpressionException invalidFilter(SimpleString filter, Throwable e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ139000: Invalid filter: {}", (Object[])new Object[]{filter, e}).getMessage();
        ActiveMQInvalidFilterExpressionException objReturn_invalidFilter = new ActiveMQInvalidFilterExpressionException(returnString);
        objReturn_invalidFilter.initCause(e);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidFilter);
        return objReturn_invalidFilter;
    }

    @Override
    public ActiveMQIllegalStateException invalidSubscriptionName() {
        String returnString = "AMQ139001: Invalid Subscription Name. It is required to set the subscription name";
        ActiveMQIllegalStateException objReturn_invalidSubscriptionName = new ActiveMQIllegalStateException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidSubscriptionName);
        return objReturn_invalidSubscriptionName;
    }

    @Override
    public ActiveMQNonExistentQueueException destinationDoesNotExist(SimpleString destination) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ139002: Destination {} does not exist", (Object[])new Object[]{destination}).getMessage();
        ActiveMQNonExistentQueueException objReturn_destinationDoesNotExist = new ActiveMQNonExistentQueueException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_destinationDoesNotExist);
        return objReturn_destinationDoesNotExist;
    }

    @Override
    public IllegalArgumentException nameCannotBeNull() {
        String returnString = "AMQ139003: name cannot be null";
        IllegalArgumentException objReturn_nameCannotBeNull = new IllegalArgumentException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne(objReturn_nameCannotBeNull);
        return objReturn_nameCannotBeNull;
    }

    @Override
    public IllegalArgumentException nameCannotBeEmpty() {
        String returnString = "AMQ139004: name cannot be empty";
        IllegalArgumentException objReturn_nameCannotBeEmpty = new IllegalArgumentException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne(objReturn_nameCannotBeEmpty);
        return objReturn_nameCannotBeEmpty;
    }

    @Override
    public IllegalStateRuntimeException callingMethodFromListenerRuntime() {
        String returnString = "AMQ139005: It is illegal to call this method from within a Message Listener";
        IllegalStateRuntimeException objReturn_callingMethodFromListenerRuntime = new IllegalStateRuntimeException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_callingMethodFromListenerRuntime);
        return objReturn_callingMethodFromListenerRuntime;
    }

    @Override
    public IllegalStateException callingMethodFromListener() {
        String returnString = "AMQ139006: It is illegal to call this method from within a Message Listener";
        IllegalStateException objReturn_callingMethodFromListener = new IllegalStateException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_callingMethodFromListener);
        return objReturn_callingMethodFromListener;
    }

    @Override
    public IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime() {
        String returnString = "AMQ139007: It is illegal to call this method from within a Completion Listener";
        IllegalStateRuntimeException objReturn_callingMethodFromCompletionListenerRuntime = new IllegalStateRuntimeException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_callingMethodFromCompletionListenerRuntime);
        return objReturn_callingMethodFromCompletionListenerRuntime;
    }

    @Override
    public IllegalStateException callingMethodFromCompletionListener() {
        String returnString = "AMQ139008: It is illegal to call this method from within a Completion Listener";
        IllegalStateException objReturn_callingMethodFromCompletionListener = new IllegalStateException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_callingMethodFromCompletionListener);
        return objReturn_callingMethodFromCompletionListener;
    }

    @Override
    public IllegalArgumentException nullArgumentNotAllowed(String type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ139009: Null {} is not allowed", (Object[])new Object[]{type}).getMessage();
        IllegalArgumentException objReturn_nullArgumentNotAllowed = new IllegalArgumentException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne(objReturn_nullArgumentNotAllowed);
        return objReturn_nullArgumentNotAllowed;
    }

    @Override
    public InvalidDestinationException nullTopic() {
        String returnString = "AMQ139010: Topic (Destination) cannot be null";
        InvalidDestinationException objReturn_nullTopic = new InvalidDestinationException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_nullTopic);
        return objReturn_nullTopic;
    }

    @Override
    public IllegalStateException onlyValidForByteOrStreamMessages() {
        String returnString = "AMQ139011: LargeMessage streaming is only possible on ByteMessage or StreamMessage";
        IllegalStateException objReturn_onlyValidForByteOrStreamMessages = new IllegalStateException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_onlyValidForByteOrStreamMessages);
        return objReturn_onlyValidForByteOrStreamMessages;
    }

    @Override
    public JMSRuntimeException invalidJavaIdentifier(String propertyName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ139012: The property name '{}' is not a valid java identifier.", (Object[])new Object[]{propertyName}).getMessage();
        JMSRuntimeException objReturn_invalidJavaIdentifier = new JMSRuntimeException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidJavaIdentifier);
        return objReturn_invalidJavaIdentifier;
    }

    @Override
    public MessageNotWriteableException messageNotWritable() {
        String returnString = "AMQ139013: Message is read-only";
        MessageNotWriteableException objReturn_messageNotWritable = new MessageNotWriteableException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_messageNotWritable);
        return objReturn_messageNotWritable;
    }

    @Override
    public MessageNotReadableException messageNotReadable() {
        String returnString = "AMQ139014: Message is write-only";
        MessageNotReadableException objReturn_messageNotReadable = new MessageNotReadableException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_messageNotReadable);
        return objReturn_messageNotReadable;
    }

    @Override
    public JMSException illegalDeliveryMode(int deliveryMode) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ139015: Illegal deliveryMode value: {}", (Object[])new Object[]{deliveryMode}).getMessage();
        JMSException objReturn_illegalDeliveryMode = new JMSException(returnString);
        ActiveMQJMSClientBundle_impl._copyStackTraceMinusOne(objReturn_illegalDeliveryMode);
        return objReturn_illegalDeliveryMode;
    }
}

