/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class RequestId {
    private final UUID uuid;

    public static RequestId random() {
        return RequestId.of(UUID.randomUUID());
    }

    public static RequestId of(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"'uuid' can not be null");
        return new RequestId(uuid);
    }

    public static RequestId of(String uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"'uuid' can not be null");
        return new RequestId(UUID.fromString(uuid));
    }

    private RequestId(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String asString() {
        return this.uuid.toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof RequestId) {
            RequestId requestId = (RequestId)o;
            return Objects.equals(this.uuid, requestId.uuid);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uuid);
    }
}

