/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public abstract class StringExtraField
implements ZipExtraField {
    private Optional<String> value;

    public StringExtraField() {
        this(Optional.empty());
    }

    public StringExtraField(Optional<String> value) {
        this.value = value;
    }

    public ZipShort getLocalFileDataLength() {
        return this.value.map(value -> value.getBytes(StandardCharsets.UTF_8).length).map(ZipShort::new).orElseThrow(() -> new RuntimeException("Value must by initialized"));
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        return this.value.map(value -> value.getBytes(StandardCharsets.UTF_8)).orElseThrow(() -> new RuntimeException("Value must by initialized"));
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void parseFromLocalFileData(byte[] buffer, int offset, int length) {
        this.value = Optional.of(new String(buffer, offset, length, StandardCharsets.UTF_8));
    }

    public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) {
        this.parseFromLocalFileData(buffer, offset, length);
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof StringExtraField) {
            StringExtraField that = (StringExtraField)o;
            return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getHeaderId(), that.getHeaderId());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.getHeaderId());
    }
}

