/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.function.Supplier;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropWizardTimeMetric
implements TimeMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropWizardTimeMetric.class);
    private final String name;
    private final Timer.Context context;
    private final Timer timer;

    public DropWizardTimeMetric(String name, Timer timer) {
        this.name = name;
        this.timer = timer;
        this.context = this.timer.time();
    }

    @VisibleForTesting
    Timer.Context getContext() {
        return this.context;
    }

    @VisibleForTesting
    Timer getTimer() {
        return this.timer;
    }

    public String name() {
        return this.name;
    }

    public TimeMetric.ExecutionResult stopAndPublish() {
        return new DropWizardExecutionResult(this.name, Duration.ofNanos(this.context.stop()), () -> Duration.ofNanos(Math.round(this.timer.getSnapshot().get999thPercentile())));
    }

    static class DropWizardExecutionResult
    implements TimeMetric.ExecutionResult {
        private final String name;
        private final Duration elasped;
        private final Supplier<Duration> p99Supplier;

        DropWizardExecutionResult(String name, Duration elasped, Supplier<Duration> p99Supplier) {
            Preconditions.checkNotNull((Object)elasped);
            Preconditions.checkNotNull(p99Supplier);
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            this.elasped = elasped;
            this.p99Supplier = p99Supplier;
        }

        public Duration elasped() {
            return this.elasped;
        }

        public TimeMetric.ExecutionResult logWhenExceedP99(Duration thresholdInNanoSeconds) {
            Preconditions.checkNotNull((Object)thresholdInNanoSeconds);
            Duration p99 = this.p99Supplier.get();
            if (this.elasped.compareTo(p99) > 0 && this.elasped.compareTo(thresholdInNanoSeconds) > 0) {
                LOGGER.warn("{} metrics took {} nano seconds to complete, exceeding its {} nano seconds p99", new Object[]{this.name, this.elasped, p99});
            }
            return this;
        }
    }
}

