/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.mailbox.indexer.MessageIdReIndexer;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailboxesRoutes;
import org.apache.james.webadmin.service.ExpireMailboxService;
import org.apache.james.webadmin.service.ExpireMailboxTask;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class MessagesRoutes
implements Routes {
    private static final String MESSAGE_ID_PARAM = ":messageId";
    private static final String BASE_PATH = "/messages";
    private static final String MESSAGE_PATH = "/messages/:messageId";
    private final TaskManager taskManager;
    private final MessageId.Factory messageIdFactory;
    private final MessageIdReIndexer reIndexer;
    private final ExpireMailboxService expireMailboxService;
    private final JsonTransformer jsonTransformer;
    private final Set<TaskFromRequestRegistry.TaskRegistration> allMessagesTaskRegistration;
    public static final String ALL_MESSAGES_TASKS = "allMessagesTasks";

    @Inject
    MessagesRoutes(TaskManager taskManager, MessageId.Factory messageIdFactory, MessageIdReIndexer reIndexer, ExpireMailboxService expireMailboxService, JsonTransformer jsonTransformer, @Named(value="allMessagesTasks") Set<TaskFromRequestRegistry.TaskRegistration> allMessagesTaskRegistration) {
        this.taskManager = taskManager;
        this.messageIdFactory = messageIdFactory;
        this.reIndexer = reIndexer;
        this.expireMailboxService = expireMailboxService;
        this.jsonTransformer = jsonTransformer;
        this.allMessagesTaskRegistration = allMessagesTaskRegistration;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        TaskFromRequest expireMailboxTaskRequest = this::expireMailbox;
        service.delete(BASE_PATH, expireMailboxTaskRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
        service.post(MESSAGE_PATH, this.reIndexMessage(), (ResponseTransformer)this.jsonTransformer);
        this.allMessagesOperations().ifPresent(route -> service.post(BASE_PATH, route, (ResponseTransformer)this.jsonTransformer));
    }

    private Task expireMailbox(Request request) {
        try {
            ExpireMailboxService.RunningOptions runningOptions = ExpireMailboxService.RunningOptions.fromParams(Optional.ofNullable(request.queryParams("byExpiresHeader")), Optional.ofNullable(request.queryParams("olderThan")), Optional.ofNullable(request.queryParams("usersPerSecond")), Optional.ofNullable(request.queryParams("mailbox")));
            return new ExpireMailboxTask(this.expireMailboxService, runningOptions);
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid arguments supplied in the user request").cause((Exception)e).haltError();
        }
    }

    private Route reIndexMessage() {
        return TaskFromRequestRegistry.builder().parameterName("task").register(MailboxesRoutes.RE_INDEX, request -> this.reIndexer.reIndex(this.extractMessageId(request))).buildAsRoute(this.taskManager);
    }

    private MessageId extractMessageId(Request request) {
        try {
            return this.messageIdFactory.fromString(request.params(MESSAGE_ID_PARAM));
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error while parsing 'messageId'").cause(e).haltError();
        }
    }

    private Optional<Route> allMessagesOperations() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.allMessagesTaskRegistration).buildAsRouteOptional(this.taskManager);
    }
}

