/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.jms.JMSCacheableMailQueue;
import org.apache.james.queue.library.AbstractMailQueueFactory;

public class JMSMailQueueFactory
extends AbstractMailQueueFactory<ManageableMailQueue> {
    protected final ConnectionFactory connectionFactory;
    protected final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    protected final MetricFactory metricFactory;
    protected final GaugeRegistry gaugeRegistry;

    @Inject
    public JMSMailQueueFactory(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.connectionFactory = connectionFactory;
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.metricFactory = metricFactory;
        this.gaugeRegistry = gaugeRegistry;
    }

    @Override
    protected ManageableMailQueue createCacheableMailQueue(MailQueueName name) {
        return new JMSCacheableMailQueue(this.connectionFactory, this.mailQueueItemDecoratorFactory, name, this.metricFactory, this.gaugeRegistry);
    }
}

