/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class JSONSearchRequestAccessLogMessage
extends JSONRequestAccessLogMessage
implements SearchRequestAccessLogMessage {
    private static final long serialVersionUID = -913390265725394880L;
    @Nullable
    private final Boolean typesOnly;
    @Nullable
    private final DereferencePolicy dereferencePolicy;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Integer timeLimit;
    @NotNull
    private final List<String> requestedAttributes;
    @Nullable
    private final SearchScope scope;
    @Nullable
    private final String baseDN = this.getString(JSONFormattedAccessLogFields.SEARCH_BASE_DN);
    @Nullable
    private final String filter = this.getString(JSONFormattedAccessLogFields.SEARCH_FILTER);

    public JSONSearchRequestAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.sizeLimit = this.getIntegerNoThrow(JSONFormattedAccessLogFields.SEARCH_SIZE_LIMIT);
        this.timeLimit = this.getIntegerNoThrow(JSONFormattedAccessLogFields.SEARCH_TIME_LIMIT_SECONDS);
        this.typesOnly = this.getBooleanNoThrow(JSONFormattedAccessLogFields.SEARCH_TYPES_ONLY);
        this.requestedAttributes = this.getStringList(JSONFormattedAccessLogFields.SEARCH_REQUESTED_ATTRIBUTES);
        Integer scopeValue = this.getIntegerNoThrow(JSONFormattedAccessLogFields.SEARCH_SCOPE_VALUE);
        this.scope = scopeValue == null ? null : SearchScope.valueOf(scopeValue);
        String derefStr = this.getString(JSONFormattedAccessLogFields.SEARCH_DEREF_POLICY);
        if (derefStr == null) {
            this.dereferencePolicy = null;
        } else {
            DereferencePolicy policy = null;
            for (DereferencePolicy p : DereferencePolicy.values()) {
                if (!p.getName().equalsIgnoreCase(derefStr)) continue;
                policy = p;
                break;
            }
            this.dereferencePolicy = policy;
        }
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.SEARCH;
    }

    @Override
    @Nullable
    public final String getBaseDN() {
        return this.baseDN;
    }

    @Override
    @Nullable
    public final SearchScope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public final String getFilter() {
        return this.filter;
    }

    @Override
    @Nullable
    public final DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    @Override
    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    @Nullable
    public final Integer getTimeLimitSeconds() {
        return this.timeLimit;
    }

    @Override
    @Nullable
    public final Boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    @NotNull
    public final List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }
}

