/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class EventFactory {
    public static RequireMailboxEvent<RequireMetadata<RequireIsDelivery<AddedFinalStage>>> added() {
        return eventId -> user -> sessionId -> mailboxId -> path -> metaData -> isDelivery -> new AddedFinalStage(eventId, path, mailboxId, user, sessionId, metaData, isDelivery);
    }

    public static RequireMailboxEvent<RequireMetadata<ExpungedFinalStage>> expunged() {
        return eventId -> user -> sessionId -> mailboxId -> path -> metaData -> new ExpungedFinalStage(eventId, path, mailboxId, user, sessionId, metaData);
    }

    public static RequireMailboxEvent<RequireUpdatedFlags<FlagsUpdatedFinalStage>> flagsUpdated() {
        return eventId -> user -> sessionId -> mailboxId -> path -> updatedFlags -> new FlagsUpdatedFinalStage(eventId, path, mailboxId, user, sessionId, (ImmutableList<UpdatedFlags>)updatedFlags);
    }

    public static RequireEventId<RequireSession<RequireMailboxId<RequireOldPath<RequireNewPath<MailboxRenamedFinalStage>>>>> mailboxRenamed() {
        return eventId -> user -> sessionId -> mailboxId -> oldPath -> newPath -> new MailboxRenamedFinalStage(eventId, oldPath, mailboxId, user, sessionId, newPath);
    }

    public static RequireMailboxEvent<RequireQuotaRoot<RequireMailboxACL<RequireQuotaCountValue<RequireQuotaSizeValue<MailboxDeletionFinalStage>>>>> mailboxDeleted() {
        return eventId -> user -> sessionId -> mailboxId -> path -> quotaRoot -> mailboxACL -> quotaCount -> quotaSize -> new MailboxDeletionFinalStage(eventId, path, mailboxACL, mailboxId, user, sessionId, quotaRoot, quotaCount, quotaSize);
    }

    public static RequireMailboxEvent<MailboxAddedFinalStage> mailboxAdded() {
        return eventId -> user -> sessionId -> mailboxId -> path -> new MailboxAddedFinalStage(eventId, path, mailboxId, user, sessionId);
    }

    public static RequireMailboxEvent<RequireAclDiff<MailboxAclUpdatedFinalStage>> aclUpdated() {
        return eventId -> user -> sessionId -> mailboxId -> path -> aclDiff -> new MailboxAclUpdatedFinalStage(eventId, path, mailboxId, user, sessionId, aclDiff);
    }

    public static RequireEventId<RequireUser<RequireQuotaRoot<RequireQuotaCount<RequireQuotaSize<RequireInstant<QuotaUsageUpdatedFinalStage>>>>>> quotaUpdated() {
        return eventId -> user -> quotaRoot -> quotaCount -> quotaSize -> instant -> new QuotaUsageUpdatedFinalStage(eventId, user, quotaRoot, (Quota<QuotaCountLimit, QuotaCountUsage>)quotaCount, (Quota<QuotaSizeLimit, QuotaSizeUsage>)quotaSize, instant);
    }

    public static RequireMailboxEvent<MailboxSubscribedFinalStage> mailboxSubscribed() {
        return eventId -> user -> sessionId -> mailboxId -> path -> new MailboxSubscribedFinalStage(eventId, path, mailboxId, user, sessionId);
    }

    public static RequireMailboxEvent<MailboxUnSubscribedFinalStage> mailboxUnSubscribed() {
        return eventId -> user -> sessionId -> mailboxId -> path -> new MailboxUnSubscribedFinalStage(eventId, path, mailboxId, user, sessionId);
    }

    public static MessageMoveEvent.Builder moved() {
        return MessageMoveEvent.builder();
    }

    public static class MailboxUnSubscribedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;

        MailboxUnSubscribedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
        }

        public MailboxEvents.MailboxUnsubscribedEvent build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxEvents.MailboxUnsubscribedEvent(this.sessionId, this.username, this.path, this.mailboxId, this.eventId);
        }
    }

    public static class MailboxSubscribedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;

        MailboxSubscribedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
        }

        public MailboxEvents.MailboxSubscribedEvent build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxEvents.MailboxSubscribedEvent(this.sessionId, this.username, this.path, this.mailboxId, this.eventId);
        }
    }

    public static final class QuotaUsageUpdatedFinalStage {
        private final Event.EventId eventId;
        private final Username username;
        private final QuotaRoot quotaRoot;
        private final Quota<QuotaCountLimit, QuotaCountUsage> countQuota;
        private final Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
        private final Instant instant;

        QuotaUsageUpdatedFinalStage(Event.EventId eventId, Username username, QuotaRoot quotaRoot, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Instant instant) {
            this.eventId = eventId;
            this.username = username;
            this.quotaRoot = quotaRoot;
            this.countQuota = countQuota;
            this.sizeQuota = sizeQuota;
            this.instant = instant;
        }

        public MailboxEvents.QuotaUsageUpdatedEvent build() {
            return new MailboxEvents.QuotaUsageUpdatedEvent(this.eventId, this.username, this.quotaRoot, this.countQuota, this.sizeQuota, this.instant);
        }
    }

    public static class FlagsUpdatedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableList<UpdatedFlags> updatedFlags;

        FlagsUpdatedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, ImmutableList<UpdatedFlags> updatedFlags) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.updatedFlags = updatedFlags;
        }

        public MailboxEvents.FlagsUpdated build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.updatedFlags);
            return new MailboxEvents.FlagsUpdated(this.sessionId, this.username, this.path, this.mailboxId, this.updatedFlags, this.eventId);
        }
    }

    public static class MailboxRenamedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath oldPath;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final MailboxPath newPath;

        MailboxRenamedFinalStage(Event.EventId eventId, MailboxPath oldPath, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, MailboxPath newPath) {
            this.eventId = eventId;
            this.oldPath = oldPath;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.newPath = newPath;
        }

        public MailboxEvents.MailboxRenamed build() {
            Preconditions.checkNotNull((Object)this.oldPath);
            Preconditions.checkNotNull((Object)this.newPath);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxEvents.MailboxRenamed(this.sessionId, this.username, this.oldPath, this.mailboxId, this.newPath, this.eventId);
        }
    }

    public static class MailboxDeletionFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxACL mailboxACL;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final QuotaRoot quotaRoot;
        private final QuotaCountUsage deletedMessageCount;
        private final QuotaSizeUsage totalDeletedSize;

        MailboxDeletionFinalStage(Event.EventId eventId, MailboxPath path, MailboxACL mailboxACL, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, QuotaRoot quotaRoot, QuotaCountUsage deletedMessageCount, QuotaSizeUsage totalDeletedSize) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxACL = mailboxACL;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.quotaRoot = quotaRoot;
            this.deletedMessageCount = deletedMessageCount;
            this.totalDeletedSize = totalDeletedSize;
        }

        public MailboxEvents.MailboxDeletion build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull((Object)this.quotaRoot);
            Preconditions.checkNotNull((Object)this.deletedMessageCount);
            Preconditions.checkNotNull((Object)this.totalDeletedSize);
            return new MailboxEvents.MailboxDeletion(this.sessionId, this.username, this.path, this.mailboxACL, this.quotaRoot, this.deletedMessageCount, this.totalDeletedSize, this.mailboxId, this.eventId);
        }
    }

    public static class MailboxAclUpdatedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final ACLDiff aclDiff;

        MailboxAclUpdatedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, ACLDiff aclDiff) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.aclDiff = aclDiff;
        }

        public MailboxEvents.MailboxACLUpdated build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull((Object)this.aclDiff);
            return new MailboxEvents.MailboxACLUpdated(this.sessionId, this.username, this.path, this.aclDiff, this.mailboxId, this.eventId);
        }
    }

    public static class ExpungedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableSortedMap<MessageUid, MessageMetaData> metaData;

        ExpungedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, Map<MessageUid, MessageMetaData> metaData) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.metaData = ImmutableSortedMap.copyOf(metaData);
        }

        public MailboxEvents.Expunged build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.metaData);
            return new MailboxEvents.Expunged(this.sessionId, this.username, this.path, this.mailboxId, this.metaData, this.eventId);
        }
    }

    public static class AddedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;
        private final ImmutableSortedMap<MessageUid, MessageMetaData> metaData;
        private final boolean isDelivery;

        AddedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId, Map<MessageUid, MessageMetaData> metaData, boolean isDelivery) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
            this.metaData = ImmutableSortedMap.copyOf(metaData);
            this.isDelivery = isDelivery;
        }

        public MailboxEvents.Added build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            Preconditions.checkNotNull(this.metaData);
            return new MailboxEvents.Added(this.sessionId, this.username, this.path, this.mailboxId, this.metaData, this.eventId, this.isDelivery);
        }
    }

    public static class MailboxAddedFinalStage {
        private final Event.EventId eventId;
        private final MailboxPath path;
        private final MailboxId mailboxId;
        private final Username username;
        private final MailboxSession.SessionId sessionId;

        MailboxAddedFinalStage(Event.EventId eventId, MailboxPath path, MailboxId mailboxId, Username username, MailboxSession.SessionId sessionId) {
            this.eventId = eventId;
            this.path = path;
            this.mailboxId = mailboxId;
            this.username = username;
            this.sessionId = sessionId;
        }

        public MailboxEvents.MailboxAdded build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.mailboxId);
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new MailboxEvents.MailboxAdded(this.sessionId, this.username, this.path, this.mailboxId, this.eventId);
        }
    }

    @FunctionalInterface
    public static interface RequireMailboxEvent<T>
    extends RequireEventId<RequireSession<RequireMailbox<T>>> {
    }

    @FunctionalInterface
    public static interface RequireInstant<T> {
        public T instant(Instant var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaSize<T> {
        public T quotaSize(Quota<QuotaSizeLimit, QuotaSizeUsage> var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaCount<T> {
        public T quotaCount(Quota<QuotaCountLimit, QuotaCountUsage> var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaSizeValue<T> {
        public T quotaSize(QuotaSizeUsage var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaCountValue<T> {
        public T quotaCount(QuotaCountUsage var1);
    }

    @FunctionalInterface
    public static interface RequireQuotaRoot<T> {
        public T quotaRoot(QuotaRoot var1);
    }

    @FunctionalInterface
    public static interface RequireUpdatedFlags<T> {
        public T updatedFlags(ImmutableList<UpdatedFlags> var1);

        default public T updatedFlags(Iterable<UpdatedFlags> updatedFlags) {
            return this.updatedFlags((ImmutableList<UpdatedFlags>)ImmutableList.copyOf(updatedFlags));
        }

        default public T updatedFlag(UpdatedFlags updatedFlags) {
            return this.updatedFlags((ImmutableList<UpdatedFlags>)ImmutableList.of((Object)updatedFlags));
        }
    }

    @FunctionalInterface
    public static interface RequireAclDiff<T> {
        public T aclDiff(ACLDiff var1);
    }

    @FunctionalInterface
    public static interface RequireIsDelivery<T> {
        public T isDelivery(boolean var1);
    }

    @FunctionalInterface
    public static interface RequireMetadata<T> {
        public T metaData(SortedMap<MessageUid, MessageMetaData> var1);

        default public T addMetaData(MessageMetaData metaData) {
            return this.metaData((SortedMap<MessageUid, MessageMetaData>)ImmutableSortedMap.of((Comparable)metaData.getUid(), (Object)metaData));
        }

        default public T addMetaData(Iterable<MessageMetaData> metaData) {
            return this.metaData((SortedMap)ImmutableList.copyOf(metaData).stream().collect(ImmutableSortedMap.toImmutableSortedMap(MessageUid::compareTo, MessageMetaData::getUid, Function.identity())));
        }

        default public T addMetaData(Iterator<MessageMetaData> metaData) {
            return this.addMetaData((Iterable<MessageMetaData>)ImmutableList.copyOf(metaData));
        }

        default public T addMessages(Iterable<MailboxMessage> messages) {
            return this.metaData((SortedMap)ImmutableList.copyOf(messages).stream().map(MailboxMessage::metaData).collect(ImmutableSortedMap.toImmutableSortedMap(MessageUid::compareTo, MessageMetaData::getUid, Function.identity())));
        }
    }

    @FunctionalInterface
    public static interface RequireOldPath<T> {
        public T oldPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireNewPath<T> {
        public T newPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireMailbox<T>
    extends RequireMailboxId<RequirePath<T>> {
        default public T mailbox(Mailbox mailbox) {
            return ((RequirePath)this.mailboxId(mailbox.getMailboxId())).mailboxPath(mailbox.generateAssociatedPath());
        }
    }

    @FunctionalInterface
    public static interface RequireMailboxACL<T> {
        public T mailboxACL(MailboxACL var1);
    }

    @FunctionalInterface
    public static interface RequirePath<T> {
        public T mailboxPath(MailboxPath var1);
    }

    @FunctionalInterface
    public static interface RequireMailboxId<T> {
        public T mailboxId(MailboxId var1);
    }

    @FunctionalInterface
    public static interface RequireSession<T>
    extends RequireUser<RequireSessionId<T>> {
        default public T mailboxSession(MailboxSession session) {
            return ((RequireSessionId)this.user(session.getUser())).sessionId(session.getSessionId());
        }
    }

    @FunctionalInterface
    public static interface RequireSessionId<T> {
        public T sessionId(MailboxSession.SessionId var1);
    }

    @FunctionalInterface
    public static interface RequireUser<T> {
        public T user(Username var1);
    }

    @FunctionalInterface
    public static interface RequireEventId<T> {
        public T eventId(Event.EventId var1);

        default public T randomEventId() {
            return this.eventId(Event.EventId.random());
        }
    }
}

