/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.core.quota.QuotaLimitValue;

public class QuotaSizeLimit
implements QuotaLimitValue<QuotaSizeLimit> {
    private static final QuotaSizeLimit UNLIMITED = new QuotaSizeLimit(Optional.empty());
    private final Optional<Long> value;

    public static QuotaSizeLimit unlimited() {
        return UNLIMITED;
    }

    public static QuotaSizeLimit size(long value) {
        return QuotaSizeLimit.size(Optional.of(value));
    }

    public static QuotaSizeLimit size(Optional<Long> value) {
        return new QuotaSizeLimit(value);
    }

    private QuotaSizeLimit(Optional<Long> value) {
        Preconditions.checkArgument((boolean)QuotaLimitValue.isValidValue(value), (Object)"Quota limit should be positive");
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value.orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean isLimited() {
        return this.value.isPresent();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value.map(String::valueOf).orElse("unlimited")).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaSizeLimit) {
            QuotaSizeLimit that = (QuotaSizeLimit)o;
            return Objects.equal(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

