/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.transaction.Mapper;

public class StoreMailboxAnnotationManager
implements MailboxAnnotationManager {
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final StoreRightManager rightManager;
    private final int limitOfAnnotations;
    private final int limitAnnotationSize;

    @Inject
    public StoreMailboxAnnotationManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, StoreRightManager rightManager) {
        this(mailboxSessionMapperFactory, rightManager, 10, 1024);
    }

    public StoreMailboxAnnotationManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, StoreRightManager rightManager, int limitOfAnnotations, int limitAnnotationSize) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.rightManager = rightManager;
        this.limitOfAnnotations = limitOfAnnotations;
        this.limitAnnotationSize = limitAnnotationSize;
    }

    public MailboxId checkThenGetMailboxId(MailboxPath path, MailboxSession session) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = (Mailbox)mailboxMapper.findMailboxByPath(path).blockOptional().orElseThrow(() -> new MailboxNotFoundException(path));
        if (!this.rightManager.hasRight(mailbox, MailboxACL.Right.Read, session)) {
            throw new InsufficientRightsException("Not enough rights on " + path);
        }
        return mailbox.getMailboxId();
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        MailboxId mailboxId = this.checkThenGetMailboxId(mailboxPath, session);
        return annotationMapper.execute(() -> annotationMapper.getAllAnnotations(mailboxId));
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        MailboxId mailboxId = this.checkThenGetMailboxId(mailboxPath, session);
        return annotationMapper.execute(() -> annotationMapper.getAnnotationsByKeys(mailboxId, keys));
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        MailboxId mailboxId = this.checkThenGetMailboxId(mailboxPath, session);
        annotationMapper.execute(Mapper.toTransaction(() -> {
            for (MailboxAnnotation annotation : mailboxAnnotations) {
                if (annotation.isNil()) {
                    annotationMapper.deleteAnnotation(mailboxId, annotation.getKey());
                    continue;
                }
                if (!this.canInsertOrUpdate(mailboxId, annotation, annotationMapper)) continue;
                annotationMapper.insertAnnotation(mailboxId, annotation);
            }
        }));
    }

    private boolean canInsertOrUpdate(MailboxId mailboxId, MailboxAnnotation annotation, AnnotationMapper annotationMapper) throws AnnotationException {
        if (annotation.size() > this.limitAnnotationSize) {
            throw new AnnotationException("annotation too big.");
        }
        if (!annotationMapper.exist(mailboxId, annotation) && annotationMapper.countAnnotations(mailboxId) >= this.limitOfAnnotations) {
            throw new AnnotationException("too many annotations.");
        }
        return true;
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        MailboxId mailboxId = this.checkThenGetMailboxId(mailboxPath, session);
        return annotationMapper.execute(() -> annotationMapper.getAnnotationsByKeysWithOneDepth(mailboxId, keys));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        MailboxId mailboxId = this.checkThenGetMailboxId(mailboxPath, session);
        return annotationMapper.execute(() -> annotationMapper.getAnnotationsByKeysWithAllDepth(mailboxId, keys));
    }
}

