/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;

public class ProtocolHandlerChainImpl
implements ProtocolHandlerChain {
    private final ProtocolHandlerLoader loader;
    private final HierarchicalConfiguration<ImmutableNode> handlerchainConfig;
    private final String jmxName;
    private final String coreHandlersPackage;
    private final String jmxHandlersPackage;
    private final List<Object> handlers = new LinkedList<Object>();

    public ProtocolHandlerChainImpl(ProtocolHandlerLoader loader, HierarchicalConfiguration<ImmutableNode> handlerchainConfig, String jmxName, Class<? extends HandlersPackage> coreHandlersPackage, Class<? extends HandlersPackage> jmxHandlersPackage) {
        this.loader = loader;
        this.handlerchainConfig = handlerchainConfig;
        this.jmxName = jmxName;
        this.coreHandlersPackage = coreHandlersPackage.getName();
        this.jmxHandlersPackage = jmxHandlersPackage.getName();
    }

    public void init() throws Exception {
        List children = this.handlerchainConfig.configurationsAt("handler");
        if (this.handlerchainConfig.getString("[@coreHandlersPackage]") == null) {
            this.handlerchainConfig.addProperty("[@coreHandlersPackage]", (Object)this.coreHandlersPackage);
        }
        String coreHandlersPackage = this.handlerchainConfig.getString("[@coreHandlersPackage]");
        if (this.handlerchainConfig.getString("[@jmxHandlersPackage]") == null) {
            this.handlerchainConfig.addProperty("[@jmxHandlersPackage]", (Object)this.jmxHandlersPackage);
        }
        String jmxHandlersPackage = this.handlerchainConfig.getString("[@jmxHandlersPackage]");
        HandlersPackage handlersPackage = (HandlersPackage)this.loader.load(coreHandlersPackage, (Configuration)this.addHandler(coreHandlersPackage));
        this.registerHandlersPackage(handlersPackage, null, children);
        if (this.handlerchainConfig.getBoolean("[@enableJmx]", true)) {
            BaseHierarchicalConfiguration builder = new BaseHierarchicalConfiguration();
            builder.addProperty("jmxName", (Object)this.jmxName);
            HandlersPackage jmxPackage = (HandlersPackage)this.loader.load(jmxHandlersPackage, (Configuration)this.addHandler(jmxHandlersPackage));
            this.registerHandlersPackage(jmxPackage, (HierarchicalConfiguration<ImmutableNode>)builder, children);
        }
        for (HierarchicalConfiguration hConf : children) {
            String className = hConf.getString("[@class]", null);
            if (className != null) {
                this.handlers.add(this.loader.load(className, (Configuration)hConf));
                continue;
            }
            throw new ConfigurationException("Missing @class attribute in configuration: " + ConfigurationUtils.toString((Configuration)hConf));
        }
        this.wireExtensibleHandlers();
    }

    private void wireExtensibleHandlers() throws WiringException {
        LinkedList<ExtensibleHandler> eHandlers = this.getHandlers(ExtensibleHandler.class);
        for (ExtensibleHandler extensibleHandler : eHandlers) {
            List markerInterfaces = extensibleHandler.getMarkerInterfaces();
            for (Class markerInterface : markerInterfaces) {
                LinkedList extensions = this.getHandlers(markerInterface);
                extensibleHandler.wireExtensions(markerInterface, extensions);
            }
        }
    }

    private void registerHandlersPackage(HandlersPackage handlersPackage, HierarchicalConfiguration<ImmutableNode> handlerConfig, List<HierarchicalConfiguration<ImmutableNode>> children) throws ConfigurationException {
        List<String> c = handlersPackage.getHandlers();
        for (String cName : c) {
            CombinedConfiguration conf = new CombinedConfiguration();
            HierarchicalConfiguration<ImmutableNode> cmdConf = this.addHandler(cName);
            conf.addConfiguration(cmdConf);
            if (handlerConfig != null) {
                conf.addConfiguration(handlerConfig);
            }
            children.add((HierarchicalConfiguration<ImmutableNode>)conf);
        }
    }

    private HierarchicalConfiguration<ImmutableNode> addHandler(String className) {
        BaseHierarchicalConfiguration hConf = new BaseHierarchicalConfiguration();
        hConf.addProperty("[@class]", (Object)className);
        return hConf;
    }

    public <T> LinkedList<T> getHandlers(Class<T> type) {
        return this.handlers.stream().filter(type::isInstance).map(h -> h).collect(Collectors.toCollection(LinkedList::new));
    }

    public void destroy() {
        LinkedList<ProtocolHandler> lHandlers = this.getHandlers(ProtocolHandler.class);
        for (ProtocolHandler handler : lHandlers) {
            handler.destroy();
        }
    }
}

