/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.events;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;

public class ConfigurationItemsAdded
implements Event {
    private final DLPAggregateId aggregateId;
    private final EventId eventId;
    private final List<DLPConfigurationItem> rules;

    public ConfigurationItemsAdded(DLPAggregateId aggregateId, EventId eventId, Collection<DLPConfigurationItem> rules) {
        Preconditions.checkNotNull((Object)aggregateId);
        Preconditions.checkNotNull((Object)eventId);
        Preconditions.checkNotNull(rules);
        Preconditions.checkArgument((!rules.isEmpty() ? 1 : 0) != 0);
        this.aggregateId = aggregateId;
        this.eventId = eventId;
        this.rules = ImmutableList.copyOf(rules);
    }

    public EventId eventId() {
        return this.eventId;
    }

    public DLPAggregateId getAggregateId() {
        return this.aggregateId;
    }

    public List<DLPConfigurationItem> getRules() {
        return this.rules;
    }

    public final boolean equals(Object o) {
        if (o instanceof ConfigurationItemsAdded) {
            ConfigurationItemsAdded that = (ConfigurationItemsAdded)o;
            return Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.rules, that.rules);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.aggregateId, this.eventId, this.rules);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("aggregateId", (Object)this.aggregateId).add("eventId", (Object)this.eventId).add("rules", this.rules).toString();
    }
}

