/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SystemMessage;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMessageProcessor
extends AbstractChainedProcessor<SystemMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMessageProcessor.class);
    private final MailboxManager mailboxManager;

    public SystemMessageProcessor(ImapProcessor next, MailboxManager mailboxManager) {
        super(SystemMessage.class, next);
        this.mailboxManager = mailboxManager;
    }

    @Override
    protected void doProcess(SystemMessage message, ImapProcessor.Responder responder, ImapSession session) {
        switch (message) {
            case FORCE_LOGOUT: {
                this.forceLogout(session);
                break;
            }
            default: {
                LOGGER.info("Unknown system message {}", (Object)message);
            }
        }
    }

    private void forceLogout(ImapSession imapSession) {
        MailboxSession session = imapSession.getMailboxSession();
        if (session == null) {
            LOGGER.trace("No mailbox session so no force logout needed");
        } else {
            session.close();
            this.mailboxManager.logout(session);
        }
    }

    @Override
    protected Closeable addContextToMDC(SystemMessage message) {
        return MDCBuilder.create().addToContext("action", "SYSTEM_MESSAGE").addToContext("message", message.toString()).build();
    }
}

