/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.james.mailbox.model.MessageRange;

public final class IdRange
implements Iterable<Long>,
Comparable<IdRange> {
    private final long lowVal;
    private long highVal;

    public static List<IdRange> mergeRanges(List<IdRange> ranges) {
        ArrayList<IdRange> copy = new ArrayList<IdRange>(ranges);
        Collections.sort(copy);
        boolean lastUid = false;
        for (int i = 0; i < copy.size() - 1; ++i) {
            IdRange current = (IdRange)copy.get(i);
            IdRange next = (IdRange)copy.get(i + 1);
            if (next.getLowVal() == Long.MAX_VALUE && next.getHighVal() == Long.MAX_VALUE) {
                if (lastUid) {
                    copy.remove(next);
                    --i;
                    continue;
                }
                lastUid = true;
                continue;
            }
            if (current.getLowVal() == Long.MAX_VALUE || current.getHighVal() == Long.MAX_VALUE || current.getHighVal() < next.getLowVal() - 1L) continue;
            if (next.getHighVal() > current.getHighVal()) {
                current.setHighVal(next.getHighVal());
            }
            copy.remove(next);
            --i;
        }
        return copy;
    }

    public static String toString(IdRange[] ranges) {
        return Optional.ofNullable(ranges).map(ImmutableList::copyOf).toString();
    }

    public static IdRange from(MessageRange messageRange) {
        return new IdRange(messageRange.getUidFrom().asLong(), messageRange.getUidTo().asLong());
    }

    public IdRange(long singleVal) {
        this.lowVal = singleVal;
        this.highVal = singleVal;
    }

    public IdRange(long lowVal, long highVal) {
        if (lowVal > highVal) {
            throw new IllegalArgumentException("LowVal must be <= HighVal");
        }
        this.lowVal = lowVal;
        this.highVal = highVal;
    }

    public long getLowVal() {
        return this.lowVal;
    }

    public long getHighVal() {
        return this.highVal;
    }

    private void setHighVal(long highVal) {
        if (this.lowVal > highVal) {
            throw new IllegalArgumentException("HighVal must be >= LowVal");
        }
        this.highVal = highVal;
    }

    public String toString() {
        return "IdRange ( " + this.lowVal + "->" + this.highVal + " )";
    }

    public String getFormattedString() {
        if (this.lowVal == this.highVal) {
            return Long.toString(this.lowVal);
        }
        return this.lowVal + ":" + this.highVal;
    }

    @Override
    public Iterator<Long> iterator() {
        long from = this.getLowVal();
        if (from == Long.MAX_VALUE) {
            from = 1L;
        }
        long to = this.getHighVal();
        return new RangeIterator(from, to);
    }

    @Override
    public int compareTo(IdRange range2) {
        if (this.getLowVal() == Long.MAX_VALUE && this.getHighVal() == Long.MAX_VALUE && range2.getLowVal() == Long.MAX_VALUE && range2.getHighVal() == Long.MAX_VALUE) {
            return 0;
        }
        if (this.getLowVal() == Long.MAX_VALUE && this.getHighVal() == Long.MAX_VALUE) {
            return 1;
        }
        if (range2.getLowVal() == Long.MAX_VALUE && range2.getHighVal() == Long.MAX_VALUE) {
            return -1;
        }
        return (int)(this.getLowVal() - range2.getLowVal());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.highVal ^ this.highVal >>> 32);
        result = 31 * result + (int)(this.lowVal ^ this.lowVal >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdRange other = (IdRange)obj;
        if (this.highVal != other.highVal) {
            return false;
        }
        return this.lowVal == other.lowVal;
    }

    private static final class RangeIterator
    implements Iterator<Long> {
        private final long to;
        private long current;

        RangeIterator(long from, long to) {
            this.to = to;
            this.current = from;
        }

        @Override
        public boolean hasNext() {
            return this.current <= this.to;
        }

        @Override
        public Long next() {
            if (this.hasNext()) {
                return this.current++;
            }
            throw new NoSuchElementException("Highest id of " + this.to + " was reached before");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }
}

