/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import io.netty.handler.ssl.SslContext;
import java.util.Map;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.OpenSSLContextFactory;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;

public class DefaultOpenSSLContextFactory
implements OpenSSLContextFactory {
    @Override
    public SslContext getClientSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        log.debugf("Creating Client OpenSSL Context with %s", (Object)config);
        return new SSLSupport(config).setSslProvider("OPENSSL").createNettyClientContext();
    }

    @Override
    public SslContext getServerSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        log.debugf("Creating Server OpenSSL Context with %s", (Object)config);
        return new SSLSupport(config).setSslProvider("OPENSSL").createNettyContext();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

