/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.AbstractUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManagerImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.ReferenceCounter;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.PrimaryRow;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.RowManagerImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.graph.DepthFirstAnalysis;
import org.apache.openjpa.lib.graph.Edge;
import org.apache.openjpa.lib.graph.Graph;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public class ConstraintUpdateManager
extends AbstractUpdateManager {
    private static final Localizer _loc = Localizer.forPackage(ConstraintUpdateManager.class);

    @Override
    public boolean orderDirty() {
        return true;
    }

    @Override
    protected PreparedStatementManager newPreparedStatementManager(JDBCStore store, Connection conn) {
        return new PreparedStatementManagerImpl(store, conn);
    }

    @Override
    protected RowManager newRowManager() {
        return new RowManagerImpl(false);
    }

    @Override
    protected Collection flush(RowManager rowMgr, PreparedStatementManager psMgr, Collection exceps) {
        RowManagerImpl rmimpl = (RowManagerImpl)rowMgr;
        this.flush(rmimpl.getAllRowDeletes(), psMgr);
        this.flush(rmimpl.getSecondaryDeletes(), psMgr);
        this.flush(rmimpl.getAllRowUpdates(), psMgr);
        Collection<PrimaryRow> inserts = rmimpl.getInserts();
        Collection<PrimaryRow> updates = rmimpl.getUpdates();
        Collection<PrimaryRow> deletes = rmimpl.getDeletes();
        Graph[] graphs = new Graph[2];
        this.analyzeForeignKeys(inserts, updates, deletes, rmimpl, graphs);
        boolean autoAssign = rmimpl.hasAutoAssignConstraints();
        try {
            this.flushGraph(graphs[0], psMgr, autoAssign);
        }
        catch (SQLException se) {
            exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
        }
        catch (OpenJPAException ke) {
            exceps = this.addException(exceps, ke);
        }
        this.flush(inserts, psMgr);
        this.flush(updates, psMgr);
        try {
            this.flushGraph(graphs[1], psMgr, autoAssign);
        }
        catch (SQLException se) {
            exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
        }
        catch (OpenJPAException ke) {
            exceps = this.addException(exceps, ke);
        }
        this.flush(deletes, psMgr);
        this.flush(rmimpl.getSecondaryUpdates(), psMgr);
        psMgr.flush();
        return exceps;
    }

    private void analyzeForeignKeys(Collection inserts, Collection updates, Collection deletes, RowManagerImpl rowMgr, Graph[] graphs) {
        HashMap<Object, OpenJPAStateManager> insertMap = null;
        if (!deletes.isEmpty() && !inserts.isEmpty()) {
            insertMap = new HashMap<Object, OpenJPAStateManager>((int)((double)inserts.size() * 1.33 + 1.0));
            for (Object insert : inserts) {
                OpenJPAStateManager sm = ((Row)insert).getPrimaryKey();
                if (sm == null || sm.getObjectId() == null) continue;
                insertMap.put(sm.getObjectId(), sm);
            }
        }
        boolean ignoreUpdates = true;
        for (Object delete : deletes) {
            ForeignKey[] fks;
            PrimaryRow row = (PrimaryRow)delete;
            if (!row.isValid()) continue;
            Row row2 = this.getInsertRow(insertMap, rowMgr, row);
            if (row2 != null) {
                ignoreUpdates = false;
                graphs[1] = this.addEdge(graphs[1], (PrimaryRow)row2, row, null);
            }
            for (ForeignKey fk : fks = row.getTable().getForeignKeys()) {
                OpenJPAStateManager fkVal = row.getForeignKeySet(fk);
                if (fkVal == null) {
                    fkVal = row.getForeignKeyWhere(fk);
                }
                if (fkVal == null || (row2 = rowMgr.getRow(fk.getPrimaryKeyTable(), 2, fkVal, false)) == null || !row2.isValid() || row2 == row) continue;
                graphs[1] = this.addEdge(graphs[1], (PrimaryRow)row2, row, fk);
            }
        }
        if (ignoreUpdates) {
            graphs[0] = this.analyzeAgainstInserts(inserts, rowMgr, graphs[0]);
        } else {
            graphs[1] = this.analyzeAgainstInserts(updates, rowMgr, graphs[1]);
            graphs[1] = this.analyzeAgainstInserts(inserts, rowMgr, graphs[1]);
        }
    }

    private Row getInsertRow(Map insertMap, RowManagerImpl rowMgr, Row row) {
        if (insertMap == null) {
            return null;
        }
        OpenJPAStateManager sm = row.getPrimaryKey();
        if (sm == null) {
            return null;
        }
        Object oid = sm.getObjectId();
        OpenJPAStateManager nsm = (OpenJPAStateManager)insertMap.get(oid);
        if (nsm == null) {
            return null;
        }
        return (row = rowMgr.getRow(row.getTable(), 1, nsm, false)) == null || row.isValid() ? row : null;
    }

    private Graph analyzeAgainstInserts(Collection rows, RowManagerImpl rowMgr, Graph graph) {
        for (Object o : rows) {
            Row row2;
            PrimaryRow row = (PrimaryRow)o;
            if (!row.isValid()) continue;
            ForeignKey[] fks = row.getTable().getForeignKeys();
            for (ForeignKey foreignKey : fks) {
                if (row.getForeignKeySet(foreignKey) == null || (row2 = rowMgr.getRow(foreignKey.getPrimaryKeyTable(), 1, row.getForeignKeySet(foreignKey), false)) == null || !row2.isValid() || row2 == row && !foreignKey.isDeferred() && !foreignKey.isLogical()) continue;
                graph = this.addEdge(graph, row, (PrimaryRow)row2, foreignKey);
            }
            Column[] cols = row.getTable().getRelationIdColumns();
            for (ReferenceCounter referenceCounter : cols) {
                OpenJPAStateManager sm = row.getRelationIdSet((Column)referenceCounter);
                if (sm == null || (row2 = rowMgr.getRow(ConstraintUpdateManager.getBaseTable(sm), 1, sm, false)) == null || !row2.isValid()) continue;
                graph = this.addEdge(graph, row, (PrimaryRow)row2, referenceCounter);
            }
        }
        return graph;
    }

    private static Table getBaseTable(OpenJPAStateManager sm) {
        ClassMapping cls = (ClassMapping)sm.getMetaData();
        while (cls.getJoinablePCSuperclassMapping() != null) {
            cls = cls.getJoinablePCSuperclassMapping();
        }
        return cls.getTable();
    }

    private Graph addEdge(Graph graph, PrimaryRow row1, PrimaryRow row2, Object fk) {
        if (graph == null) {
            graph = new Graph();
        }
        row1.setDependent(true);
        row2.setDependent(true);
        graph.addNode(row1);
        graph.addNode(row2);
        Edge edge = new Edge(row1, row2, true);
        edge.setUserObject(fk);
        graph.addEdge(edge);
        return graph;
    }

    protected void flushGraph(Graph graph, PreparedStatementManager psMgr, boolean autoAssign) throws SQLException {
        if (graph == null) {
            return;
        }
        DepthFirstAnalysis dfa = this.newDepthFirstAnalysis(graph, autoAssign);
        LinkedList insertUpdates = new LinkedList();
        LinkedList deleteUpdates = new LinkedList();
        boolean recalculate = this.resolveCycles(graph, dfa.getEdges(2), deleteUpdates, insertUpdates);
        if (recalculate |= this.resolveCycles(graph, dfa.getEdges(3), deleteUpdates, insertUpdates)) {
            dfa = this.recalculateDepthFirstAnalysis(graph, autoAssign);
        }
        List<Object> nodes = dfa.getSortedNodes();
        this.flush(deleteUpdates, nodes, psMgr);
        this.flush(insertUpdates, psMgr);
    }

    protected void flush(Collection deleteUpdates, Collection nodes, PreparedStatementManager psMgr) {
        this.flush(deleteUpdates, psMgr);
        for (Object node : nodes) {
            psMgr.flush((RowImpl)node);
        }
    }

    private void addDeleteUpdate(Edge edge, Collection deleteUpdates) throws SQLException {
        PrimaryRow row = (PrimaryRow)edge.getTo();
        PrimaryRow update = new PrimaryRow(row.getTable(), 0, null);
        row.copyInto(update, true);
        if (edge.getUserObject() instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)edge.getUserObject();
            ((RowImpl)update).setForeignKey(fk, row.getForeignKeyIO(fk), null);
        } else {
            update.setNull((Column)edge.getUserObject());
        }
        deleteUpdates.add(update);
    }

    private void addInsertUpdate(PrimaryRow row, Edge edge, Collection insertUpdates) throws SQLException {
        PrimaryRow update = new PrimaryRow(row.getTable(), 0, null);
        if (row.getAction() == 1) {
            if (row.getPrimaryKey() == null) {
                throw new InternalException(_loc.get("ref-cycle"));
            }
            ((RowImpl)update).wherePrimaryKey(row.getPrimaryKey());
        } else {
            row.copyInto(update, true);
        }
        if (edge.getUserObject() instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)edge.getUserObject();
            ((RowImpl)update).setForeignKey(fk, row.getForeignKeyIO(fk), row.getForeignKeySet(fk));
            row.clearForeignKey(fk);
        } else {
            Column col = (Column)edge.getUserObject();
            ((RowImpl)update).setRelationId(col, row.getRelationIdSet(col), row.getRelationIdCallback(col));
            row.clearRelationId(col);
        }
        insertUpdates.add(update);
    }

    private Edge findBreakableLink(List cycle) {
        Edge breakableLink = null;
        for (Object o : cycle) {
            Edge edge = (Edge)o;
            Object userObject = edge.getUserObject();
            if (userObject instanceof ForeignKey) {
                if (((ForeignKey)userObject).hasNotNullColumns()) continue;
                breakableLink = edge;
                break;
            }
            if (!(userObject instanceof Column) || ((Column)userObject).isNotNull()) continue;
            breakableLink = edge;
            break;
        }
        return breakableLink;
    }

    private DepthFirstAnalysis recalculateDepthFirstAnalysis(Graph graph, boolean autoAssign) {
        graph.clearTraversal();
        DepthFirstAnalysis dfa = this.newDepthFirstAnalysis(graph, autoAssign);
        assert (dfa.hasNoCycles()) : _loc.get("graph-not-cycle-free");
        return dfa;
    }

    private boolean resolveCycles(Graph graph, Collection edges, Collection deleteUpdates, Collection insertUpdates) throws SQLException {
        boolean recalculate = false;
        for (Object o : edges) {
            Edge edge = (Edge)o;
            List<Edge> cycle = edge.getCycle();
            if (cycle == null) continue;
            Edge breakableLink = this.findBreakableLink(cycle);
            if (breakableLink == null) {
                throw new UserException(_loc.get("no-nullable-fk"));
            }
            if (edge != breakableLink) {
                recalculate = true;
            }
            if (breakableLink.isRemovedFromGraph()) continue;
            PrimaryRow row = (PrimaryRow)breakableLink.getFrom();
            if (row.getAction() == 2) {
                this.addDeleteUpdate(breakableLink, deleteUpdates);
            } else {
                this.addInsertUpdate(row, breakableLink, insertUpdates);
            }
            graph.removeEdge(breakableLink);
        }
        return recalculate;
    }

    protected DepthFirstAnalysis newDepthFirstAnalysis(Graph graph, boolean autoAssign) {
        return new DepthFirstAnalysis(graph);
    }

    protected void flush(Collection rows, PreparedStatementManager psMgr) {
        if (rows.size() == 0) {
            return;
        }
        for (Object o : rows) {
            RowImpl row = (RowImpl)o;
            if (row.isFlushed() || !row.isValid() || row.isDependent()) continue;
            psMgr.flush(row);
            row.setFlushed(true);
        }
    }
}

