/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Header;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;

public class AuthHeader
extends Header {
    protected AuthToken token = null;

    public AuthHeader() {
    }

    public AuthHeader(AuthToken token) {
        this.token = token;
    }

    public void setToken(AuthToken token) {
        this.token = token;
    }

    public AuthToken getToken() {
        return this.token;
    }

    public AuthHeader token(AuthToken token) {
        this.token = token;
        return this;
    }

    public AuthToken token() {
        return this.token;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        AuthHeader.writeAuthToken(out, this.token);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.token = AuthHeader.readAuthToken(in);
    }

    @Override
    public int size() {
        return AuthHeader.sizeOf(this.token);
    }

    @Override
    public String toString() {
        return "token=" + this.token;
    }

    protected static void writeAuthToken(DataOutput out, AuthToken tok) throws Exception {
        out.writeByte(tok == null ? 0 : 1);
        if (tok == null) {
            return;
        }
        short id = ClassConfigurator.getMagicNumber(tok.getClass());
        out.writeShort(id);
        if (id < 0) {
            String classname = tok.getClass().getName();
            out.writeUTF(classname);
        }
        tok.writeTo(out);
    }

    protected static AuthToken readAuthToken(DataInput in) throws Exception {
        Class<?> clazz;
        if (in.readByte() == 0) {
            return null;
        }
        short id = in.readShort();
        if (id >= 0) {
            clazz = ClassConfigurator.get(id);
        } else {
            String classname = in.readUTF();
            clazz = Class.forName(classname);
        }
        AuthToken retval = (AuthToken)clazz.newInstance();
        retval.readFrom(in);
        return retval;
    }

    protected static int sizeOf(AuthToken tok) {
        int retval = 1;
        if (tok == null) {
            return retval;
        }
        retval += 2;
        short id = ClassConfigurator.getMagicNumber(tok.getClass());
        if (id < 0) {
            String classname = tok.getClass().getName();
            retval += classname.length() + 2;
        }
        return retval += tok.size();
    }
}

