/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.canon.DigestOutputStream;
import org.apache.james.jdkim.canon.LimitedOutputStream;
import org.apache.james.jdkim.canon.RelaxedBodyCanonicalizer;
import org.apache.james.jdkim.canon.SimpleBodyCanonicalizer;
import org.apache.james.jdkim.exceptions.PermFailException;

public class BodyHasherImpl
implements BodyHasher {
    private static final boolean DEEP_DEBUG = false;
    private SignatureRecord sign;
    private DigestOutputStream digesterOS;
    private OutputStream out;

    public BodyHasherImpl(SignatureRecord sign) throws PermFailException {
        DigestOutputStream dout;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(((Object)sign.getHashAlgo()).toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PermFailException("Unsupported algorythm: " + sign.getHashAlgo(), e);
        }
        try {
            sign.validate();
        }
        catch (IllegalStateException e) {
            throw new PermFailException("Invalid signature template", e);
        }
        int limit = sign.getBodyHashLimit();
        boolean relaxedBody = "relaxed".equals(sign.getBodyCanonicalisationMethod());
        if (!relaxedBody && !"simple".equals(sign.getBodyCanonicalisationMethod())) {
            throw new PermFailException("Unsupported body canonicalization method: " + sign.getBodyCanonicalisationMethod());
        }
        OutputStream out = dout = new DigestOutputStream(md);
        out = BodyHasherImpl.prepareCanonicalizerOutputStream(limit, relaxedBody, out);
        this.setSignatureRecord(sign);
        this.setDigestOutputStream(dout);
        this.setOutputStream(out);
    }

    static OutputStream prepareCanonicalizerOutputStream(int limit, boolean relaxedBody, OutputStream dout) {
        OutputStream out = dout;
        if (limit != -1) {
            out = new LimitedOutputStream(out, limit);
        }
        out = relaxedBody ? new RelaxedBodyCanonicalizer(out) : new SimpleBodyCanonicalizer(out);
        return out;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public SignatureRecord getSignatureRecord() {
        return this.sign;
    }

    private DigestOutputStream getDigesterOutputStream() {
        return this.digesterOS;
    }

    public byte[] getDigest() {
        return this.getDigesterOutputStream().getDigest();
    }

    public void setSignatureRecord(SignatureRecord sign) {
        this.sign = sign;
    }

    public void setDigestOutputStream(DigestOutputStream dout) {
        this.digesterOS = dout;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }
}

