/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyStreamImapRequestLineReader;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ImapRequestFrameDecoder
extends FrameDecoder
implements NettyConstants {
    public static final int UNAUTHENTICATE_LITERAL_MAX_SIZE = Optional.ofNullable(System.getProperty("james.imap.unauthenticated.literal.max.size")).map(Integer::parseInt).orElse(8192);
    private final ImapDecoder decoder;
    private final int inMemorySizeLimit;
    private final int literalSizeLimit;
    private final int maxFrameLength;
    @VisibleForTesting
    static final String NEEDED_DATA = "NEEDED_DATA";
    private static final String STORED_DATA = "STORED_DATA";
    private static final String WRITTEN_DATA = "WRITTEN_DATA";
    private static final String OUTPUT_STREAM = "OUTPUT_STREAM";

    public ImapRequestFrameDecoder(ImapDecoder decoder, int inMemorySizeLimit, int literalSizeLimit, int maxFrameLength) {
        this.decoder = decoder;
        this.inMemorySizeLimit = inMemorySizeLimit;
        this.literalSizeLimit = literalSizeLimit;
        this.maxFrameLength = maxFrameLength;
    }

    private int literalSizeLimit(ImapSession session) {
        if (session == null) {
            return UNAUTHENTICATE_LITERAL_MAX_SIZE;
        }
        if (session.getState() == ImapSessionState.NON_AUTHENTICATED || session.getState() == ImapSessionState.LOGOUT) {
            return UNAUTHENTICATE_LITERAL_MAX_SIZE;
        }
        return this.literalSizeLimit;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.setAttachment(new HashMap());
        super.channelOpen(ctx, e);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int size;
        ImapSession session;
        Map attachment;
        block17: {
            boolean retry;
            block15: {
                block16: {
                    buffer.markReaderIndex();
                    retry = false;
                    attachment = (Map)ctx.getAttachment();
                    session = (ImapSession)attributes.get(channel);
                    size = -1;
                    if (!attachment.containsKey(NEEDED_DATA)) break block15;
                    retry = true;
                    size = (Integer)attachment.get(NEEDED_DATA);
                    if (size == -1 || size <= buffer.readableBytes()) break block16;
                    if (this.inMemorySizeLimit > 0 && this.inMemorySizeLimit < size) {
                        int amount;
                        OutputStream out;
                        int written;
                        File f;
                        if (attachment.containsKey(STORED_DATA)) {
                            f = (File)attachment.get(STORED_DATA);
                            written = (Integer)attachment.get(WRITTEN_DATA);
                            out = (OutputStream)attachment.get(OUTPUT_STREAM);
                        } else {
                            f = Files.createTempFile("imap-literal", ".tmp", new FileAttribute[0]).toFile();
                            attachment.put(STORED_DATA, f);
                            written = 0;
                            attachment.put(WRITTEN_DATA, written);
                            out = new FileOutputStream(f, true);
                            attachment.put(OUTPUT_STREAM, out);
                        }
                        try {
                            amount = Math.min(buffer.readableBytes(), size - written);
                            buffer.readBytes(out, amount);
                        }
                        catch (Exception e) {
                            try {
                                out.close();
                                throw e;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw e;
                        }
                        if ((written += amount) != size) {
                            attachment.put(WRITTEN_DATA, written);
                            return null;
                        }
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        NettyStreamImapRequestLineReader nettyStreamImapRequestLineReader = new NettyStreamImapRequestLineReader(channel, f, retry);
                        break block17;
                    } else {
                        buffer.resetReaderIndex();
                        return null;
                    }
                }
                NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry, this.literalSizeLimit(session), this.maxFrameLength);
                break block17;
            }
            NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry, this.literalSizeLimit(session), this.maxFrameLength);
        }
        if (session != null && session.getState() != ImapSessionState.LOGOUT) {
            try {
                void var5_21;
                ImapMessage message = this.decoder.decode((ImapRequestLineReader)var5_21, session);
                if (size == -1) {
                    var5_21.consumeLine();
                }
                ((SwitchableLineBasedFrameDecoder)channel.getPipeline().get("framer")).enableFraming();
                attachment.clear();
                return message;
            }
            catch (NettyImapRequestLineReader.NotEnoughDataException e) {
                int neededData = e.getNeededSize();
                attachment.put(NEEDED_DATA, neededData);
                ChannelPipeline pipeline = channel.getPipeline();
                ChannelHandlerContext framerContext = pipeline.getContext("framer");
                SwitchableLineBasedFrameDecoder framer = (SwitchableLineBasedFrameDecoder)pipeline.get("framer");
                framer.disableFraming(framerContext);
                buffer.resetReaderIndex();
                return null;
            }
        }
        if (!channel.isConnected()) return null;
        channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        return null;
    }

    protected synchronized ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        int size;
        Map attachment = (Map)ctx.getAttachment();
        Object sizeAsObject = attachment.get(NEEDED_DATA);
        if (sizeAsObject != null && (size = ((Integer)sizeAsObject).intValue()) > 0) {
            int sanitizedInMemorySizeLimit = Math.max(0, this.inMemorySizeLimit);
            int sanitizedSize = Math.min(sanitizedInMemorySizeLimit, size);
            return ChannelBuffers.dynamicBuffer((int)sanitizedSize, (ChannelBufferFactory)ctx.getChannel().getConfig().getBufferFactory());
        }
        return super.newCumulationBuffer(ctx, minimumCapacity);
    }
}

