/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.apache.activemq.jms.pool.ConnectionKey;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.IntrospectionSupport;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.apache.activemq.jms.pool.XaConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaPooledConnectionFactory
extends PooledConnectionFactory
implements ObjectFactory,
Serializable {
    private static final transient Logger LOG = LoggerFactory.getLogger(XaPooledConnectionFactory.class);
    private static final long serialVersionUID = -6545688026350913005L;
    private TransactionManager transactionManager;
    private Boolean tmFromJndi = false;
    private String tmJndiName = "java:/TransactionManager";

    public TransactionManager getTransactionManager() {
        block3: {
            if (this.transactionManager == null && this.tmFromJndi.booleanValue()) {
                try {
                    this.transactionManager = (TransactionManager)new InitialContext().lookup(this.getTmJndiName());
                }
                catch (Throwable ignored) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("exception on tmFromJndi: " + this.getTmJndiName(), ignored);
                }
            }
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void setConnectionFactory(Object toUse) {
        if (!(toUse instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("connectionFactory should implement javax.xml.XAConnectionFactory");
        }
        this.connectionFactory = toUse;
    }

    @Override
    protected Connection createConnection(ConnectionKey key) throws JMSException {
        if (this.connectionFactory instanceof XAConnectionFactory) {
            if (key.getUserName() == null && key.getPassword() == null) {
                return ((XAConnectionFactory)this.connectionFactory).createXAConnection();
            }
            return ((XAConnectionFactory)this.connectionFactory).createXAConnection(key.getUserName(), key.getPassword());
        }
        throw new IllegalStateException("connectionFactory should implement javax.jms.XAConnectionFactory");
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new XaConnectionPool(connection, this.getTransactionManager());
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        this.setTmFromJndi(true);
        this.configFromJndiConf(obj);
        if (environment != null) {
            IntrospectionSupport.setProperties(this, environment);
        }
        return this;
    }

    private void configFromJndiConf(Object rootContextName) {
        block4: {
            if (rootContextName instanceof String) {
                Object name = (String)rootContextName;
                name = ((String)name).substring(0, ((String)name).lastIndexOf(47)) + "/conf" + ((String)name).substring(((String)name).lastIndexOf(47));
                try {
                    InitialContext ctx = new InitialContext();
                    NamingEnumeration<Binding> bindings = ctx.listBindings((String)name);
                    while (bindings.hasMore()) {
                        Binding bd = bindings.next();
                        IntrospectionSupport.setProperty(this, bd.getName(), bd.getObject());
                    }
                }
                catch (Exception ignored) {
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("exception on config from jndi: " + (String)name, (Throwable)ignored);
                }
            }
        }
    }

    public String getTmJndiName() {
        return this.tmJndiName;
    }

    public void setTmJndiName(String tmJndiName) {
        this.tmJndiName = tmJndiName;
    }

    public Boolean isTmFromJndi() {
        return this.tmFromJndi;
    }

    public void setTmFromJndi(Boolean tmFromJndi) {
        this.tmFromJndi = tmFromJndi;
    }
}

