/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToBackendSetRoutingType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RouteToBackendSetRequestControl
extends Control {
    @NotNull
    public static final String ROUTE_TO_BACKEND_SET_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.35";
    private static final long serialVersionUID = -2486448910813783450L;
    @NotNull
    private final RouteToBackendSetRoutingType routingType;
    @Nullable
    private final Set<String> absoluteBackendSetIDs;
    @Nullable
    private final Set<String> routingHintFallbackSetIDs;
    @Nullable
    private final Set<String> routingHintFirstGuessSetIDs;
    @NotNull
    private final String entryBalancingRequestProcessorID;

    private RouteToBackendSetRequestControl(boolean isCritical, @NotNull ASN1OctetString encodedValue, @NotNull String entryBalancingRequestProcessorID, @NotNull RouteToBackendSetRoutingType routingType, @Nullable Collection<String> absoluteBackendSetIDs, @Nullable Collection<String> routingHintFirstGuessSetIDs, @Nullable Collection<String> routingHintFallbackSetIDs) {
        super(ROUTE_TO_BACKEND_SET_REQUEST_OID, isCritical, encodedValue);
        this.entryBalancingRequestProcessorID = entryBalancingRequestProcessorID;
        this.routingType = routingType;
        this.absoluteBackendSetIDs = absoluteBackendSetIDs == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(absoluteBackendSetIDs));
        this.routingHintFirstGuessSetIDs = routingHintFirstGuessSetIDs == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(routingHintFirstGuessSetIDs));
        this.routingHintFallbackSetIDs = routingHintFallbackSetIDs == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(routingHintFallbackSetIDs));
    }

    public RouteToBackendSetRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.entryBalancingRequestProcessorID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.routingType = RouteToBackendSetRoutingType.valueOf(elements[1].getType());
            if (this.routingType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_UNKNOWN_ROUTING_TYPE.get(StaticUtils.toHex(elements[1].getType())));
            }
            if (this.routingType == RouteToBackendSetRoutingType.ABSOLUTE_ROUTING) {
                ASN1Element[] arElements = ASN1Set.decodeAsSet(elements[1]).elements();
                LinkedHashSet<String> arSet = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(arElements.length));
                for (ASN1Element e : arElements) {
                    arSet.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                }
                this.absoluteBackendSetIDs = Collections.unmodifiableSet(arSet);
                if (this.absoluteBackendSetIDs.isEmpty()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_ABSOLUTE_SET_EMPTY.get());
                }
                this.routingHintFirstGuessSetIDs = null;
                this.routingHintFallbackSetIDs = null;
            } else {
                ASN1Element[] hintElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                ASN1Element[] firstGuessElements = ASN1Set.decodeAsSet(hintElements[0]).elements();
                LinkedHashSet<String> firstGuessSet = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(firstGuessElements.length));
                for (ASN1Element e : firstGuessElements) {
                    firstGuessSet.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                }
                this.routingHintFirstGuessSetIDs = Collections.unmodifiableSet(firstGuessSet);
                if (this.routingHintFirstGuessSetIDs.isEmpty()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_HINT_FIRST_SET_EMPTY.get());
                }
                if (hintElements.length == 1) {
                    this.routingHintFallbackSetIDs = null;
                } else {
                    ASN1Element[] fallbackElements = ASN1Set.decodeAsSet(hintElements[1]).elements();
                    LinkedHashSet<String> fallbackSet = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(fallbackElements.length));
                    for (ASN1Element e : fallbackElements) {
                        fallbackSet.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                    }
                    this.routingHintFallbackSetIDs = Collections.unmodifiableSet(fallbackSet);
                    if (this.routingHintFallbackSetIDs.isEmpty()) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_HINT_FALLBACK_SET_EMPTY.get());
                    }
                }
                this.absoluteBackendSetIDs = null;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ROUTE_TO_BACKEND_SET_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static RouteToBackendSetRequestControl createAbsoluteRoutingRequest(boolean isCritical, @NotNull String entryBalancingRequestProcessorID, @NotNull String backendSetID) {
        return RouteToBackendSetRequestControl.createAbsoluteRoutingRequest(isCritical, entryBalancingRequestProcessorID, Collections.singletonList(backendSetID));
    }

    @NotNull
    public static RouteToBackendSetRequestControl createAbsoluteRoutingRequest(boolean isCritical, @NotNull String entryBalancingRequestProcessorID, @NotNull Collection<String> backendSetIDs) {
        Validator.ensureNotNull(backendSetIDs);
        Validator.ensureFalse(backendSetIDs.isEmpty());
        ArrayList<ASN1OctetString> backendSetIDElements = new ArrayList<ASN1OctetString>(backendSetIDs.size());
        for (String s : backendSetIDs) {
            backendSetIDElements.add(new ASN1OctetString(s));
        }
        RouteToBackendSetRoutingType routingType = RouteToBackendSetRoutingType.ABSOLUTE_ROUTING;
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(entryBalancingRequestProcessorID), new ASN1Set(routingType.getBERType(), backendSetIDElements));
        return new RouteToBackendSetRequestControl(isCritical, new ASN1OctetString(valueSequence.encode()), entryBalancingRequestProcessorID, routingType, backendSetIDs, null, null);
    }

    @NotNull
    public static RouteToBackendSetRequestControl createRoutingHintRequest(boolean isCritical, @NotNull String entryBalancingRequestProcessorID, @NotNull String firstGuessSetID, @Nullable Collection<String> fallbackSetIDs) {
        return RouteToBackendSetRequestControl.createRoutingHintRequest(isCritical, entryBalancingRequestProcessorID, Collections.singletonList(firstGuessSetID), fallbackSetIDs);
    }

    @NotNull
    public static RouteToBackendSetRequestControl createRoutingHintRequest(boolean isCritical, @NotNull String entryBalancingRequestProcessorID, @NotNull Collection<String> firstGuessSetIDs, @Nullable Collection<String> fallbackSetIDs) {
        Validator.ensureNotNull(firstGuessSetIDs);
        Validator.ensureFalse(firstGuessSetIDs.isEmpty());
        if (fallbackSetIDs != null) {
            Validator.ensureFalse(fallbackSetIDs.isEmpty());
        }
        ArrayList<ASN1Set> backendSetsElements = new ArrayList<ASN1Set>(2);
        ArrayList<ASN1OctetString> firstGuessElements = new ArrayList<ASN1OctetString>(firstGuessSetIDs.size());
        for (String s : firstGuessSetIDs) {
            firstGuessElements.add(new ASN1OctetString(s));
        }
        backendSetsElements.add(new ASN1Set(firstGuessElements));
        if (fallbackSetIDs != null) {
            ArrayList<ASN1OctetString> fallbackElements = new ArrayList<ASN1OctetString>(fallbackSetIDs.size());
            for (String s : fallbackSetIDs) {
                fallbackElements.add(new ASN1OctetString(s));
            }
            backendSetsElements.add(new ASN1Set(fallbackElements));
        }
        RouteToBackendSetRoutingType routingType = RouteToBackendSetRoutingType.ROUTING_HINT;
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(entryBalancingRequestProcessorID), new ASN1Sequence(routingType.getBERType(), backendSetsElements));
        return new RouteToBackendSetRequestControl(isCritical, new ASN1OctetString(valueSequence.encode()), entryBalancingRequestProcessorID, routingType, null, firstGuessSetIDs, fallbackSetIDs);
    }

    @NotNull
    public String getEntryBalancingRequestProcessorID() {
        return this.entryBalancingRequestProcessorID;
    }

    @NotNull
    public RouteToBackendSetRoutingType getRoutingType() {
        return this.routingType;
    }

    @Nullable
    public Set<String> getAbsoluteBackendSetIDs() {
        return this.absoluteBackendSetIDs;
    }

    @Nullable
    public Set<String> getRoutingHintFirstGuessSetIDs() {
        return this.routingHintFirstGuessSetIDs;
    }

    @Nullable
    public Set<String> getRoutingHintFallbackSetIDs() {
        return this.routingHintFallbackSetIDs;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ROUTE_TO_BACKEND_SET_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RouteToBackendSetRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", entryBalancingRequestProcessorID='");
        buffer.append(this.entryBalancingRequestProcessorID);
        buffer.append("', routingType='");
        Iterator<String> iterator = null;
        switch (this.routingType) {
            case ABSOLUTE_ROUTING: {
                buffer.append("absolute', backendSetIDs={");
                iterator = this.absoluteBackendSetIDs.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
                break;
            }
            case ROUTING_HINT: {
                buffer.append("hint', firstGuessSetIDs={");
                iterator = this.routingHintFirstGuessSetIDs.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
                if (this.routingHintFallbackSetIDs == null) break;
                buffer.append(", fallbackSetIDs={");
                iterator = this.routingHintFallbackSetIDs.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

