/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.QuotaOperation;

public class CurrentQuotas {
    private final QuotaCountUsage count;
    private final QuotaSizeUsage size;

    public static CurrentQuotas emptyQuotas() {
        return new CurrentQuotas(QuotaCountUsage.count((long)0L), QuotaSizeUsage.size((long)0L));
    }

    public static CurrentQuotas from(QuotaOperation quotaOperation) {
        return new CurrentQuotas(quotaOperation.count(), quotaOperation.size());
    }

    public CurrentQuotas(QuotaCountUsage count, QuotaSizeUsage size) {
        Preconditions.checkNotNull((Object)count);
        Preconditions.checkNotNull((Object)size);
        this.count = count;
        this.size = size;
    }

    public QuotaCountUsage count() {
        return this.count;
    }

    public QuotaSizeUsage size() {
        return this.size;
    }

    public CurrentQuotas increase(CurrentQuotas updateQuotas) {
        return new CurrentQuotas(QuotaCountUsage.count((long)(this.count.asLong() + updateQuotas.count.asLong())), QuotaSizeUsage.size((long)(this.size.asLong() + updateQuotas.size.asLong())));
    }

    public CurrentQuotas decrease(CurrentQuotas updateQuotas) {
        return new CurrentQuotas(QuotaCountUsage.count((long)(this.count.asLong() - updateQuotas.count.asLong())), QuotaSizeUsage.size((long)(this.size.asLong() - updateQuotas.size.asLong())));
    }

    public final boolean equals(Object o) {
        if (o instanceof CurrentQuotas) {
            CurrentQuotas currentQuotas = (CurrentQuotas)o;
            return Objects.equals(this.count, currentQuotas.count) && Objects.equals(this.size, currentQuotas.size);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.count, this.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", (Object)this.count).add("size", (Object)this.size).toString();
    }
}

