/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.exceptions.InvalidOriginMessageForMDNException;
import org.apache.james.jmap.draft.model.MDNDisposition;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.ReportingUserAgent;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.util.MimeUtil;

@JsonDeserialize(builder=Builder.class)
public class JmapMDN {
    public static final String DISPOSITION_NOTIFICATION_TO = "Disposition-Notification-To";
    public static final String RETURN_PATH = "Return-Path";
    private final MessageId messageId;
    private final String subject;
    private final String textBody;
    private final String reportingUA;
    private final MDNDisposition disposition;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    JmapMDN(MessageId messageId, String subject, String textBody, String reportingUA, MDNDisposition disposition) {
        this.messageId = messageId;
        this.subject = subject;
        this.textBody = textBody;
        this.reportingUA = reportingUA;
        this.disposition = disposition;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public ReportingUserAgent getReportingUA() {
        return ReportingUserAgent.builder().userAgentName(this.reportingUA).build();
    }

    public MDNDisposition getDisposition() {
        return this.disposition;
    }

    public Message generateMDNMessage(Message originalMessage, MailboxSession mailboxSession) throws ParseException, IOException, InvalidOriginMessageForMDNException {
        Username username = mailboxSession.getUser();
        return MDN.builder().report(this.generateReport(originalMessage, mailboxSession)).humanReadableText(this.textBody).build().asMime4JMessageBuilder().setTo(this.getSenderAddress(originalMessage)).setFrom(username.asString()).setSubject(this.subject).setDate(new Date()).setMessageId(MimeUtil.createUniqueMessageId((String)username.getDomainPart().map(Domain::name).orElse(null))).build();
    }

    private String getSenderAddress(Message originalMessage) throws InvalidOriginMessageForMDNException {
        return this.getAddressForHeader(originalMessage, DISPOSITION_NOTIFICATION_TO).orElseThrow(() -> InvalidOriginMessageForMDNException.missingHeader(DISPOSITION_NOTIFICATION_TO)).getAddress();
    }

    private Optional<Mailbox> getAddressForHeader(Message originalMessage, String fieldName) {
        return Optional.ofNullable(originalMessage.getHeader().getFields(fieldName)).orElse((List)ImmutableList.of()).stream().map(field -> (AddressListField)AddressListFieldLenientImpl.PARSER.parse(field, new DecodeMonitor())).findFirst().map(AddressListField::getAddressList).map(AddressList::flatten).map(Collection::stream).orElse(Stream.of(new Mailbox[0])).findFirst();
    }

    private MDNReport generateReport(Message originalMessage, MailboxSession mailboxSession) throws InvalidOriginMessageForMDNException {
        if (originalMessage.getMessageId() == null) {
            throw InvalidOriginMessageForMDNException.missingHeader("Message-ID");
        }
        return MDNReport.builder().dispositionField(this.generateDisposition()).originalRecipientField(mailboxSession.getUser().asString()).originalMessageIdField(originalMessage.getMessageId()).finalRecipientField(mailboxSession.getUser().asString()).reportingUserAgentField(this.getReportingUA()).build();
    }

    private Disposition generateDisposition() {
        return Disposition.builder().actionMode(this.disposition.getActionMode()).sendingMode(this.disposition.getSendingMode()).type(this.disposition.getType()).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof JmapMDN) {
            JmapMDN that = (JmapMDN)o;
            return Objects.equals(this.messageId, that.messageId) && Objects.equals(this.subject, that.subject) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.reportingUA, that.reportingUA) && Objects.equals(this.disposition, that.disposition);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.messageId, this.subject, this.textBody, this.reportingUA, this.disposition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("subject", (Object)this.subject).add("textBody", (Object)this.textBody).add("reportingUA", (Object)this.reportingUA).add("mdnDisposition", (Object)this.disposition).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private MessageId messageId;
        private String subject;
        private String textBody;
        private String reportingUA;
        private MDNDisposition disposition;

        public Builder messageId(MessageId messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder textBody(String textBody) {
            this.textBody = textBody;
            return this;
        }

        public Builder reportingUA(String reportingUA) {
            this.reportingUA = reportingUA;
            return this;
        }

        public Builder disposition(MDNDisposition disposition) {
            this.disposition = disposition;
            return this;
        }

        public JmapMDN build() {
            Preconditions.checkState((this.messageId != null ? 1 : 0) != 0, (Object)"'messageId' is mandatory");
            Preconditions.checkState((this.subject != null ? 1 : 0) != 0, (Object)"'subject' is mandatory");
            Preconditions.checkState((this.textBody != null ? 1 : 0) != 0, (Object)"'textBody' is mandatory");
            Preconditions.checkState((this.reportingUA != null ? 1 : 0) != 0, (Object)"'reportingUA' is mandatory");
            Preconditions.checkState((this.disposition != null ? 1 : 0) != 0, (Object)"'disposition' is mandatory");
            return new JmapMDN(this.messageId, this.subject, this.textBody, this.reportingUA, this.disposition);
        }
    }
}

