/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.api;

import java.util.Iterator;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.reactivestreams.Publisher;

public interface UsersRepository {
    public void addUser(Username var1, String var2) throws UsersRepositoryException;

    public User getUserByName(Username var1) throws UsersRepositoryException;

    public void updateUser(User var1) throws UsersRepositoryException;

    public void removeUser(Username var1) throws UsersRepositoryException;

    public boolean contains(Username var1) throws UsersRepositoryException;

    public Publisher<Boolean> containsReactive(Username var1);

    public boolean test(Username var1, String var2) throws UsersRepositoryException;

    public int countUsers() throws UsersRepositoryException;

    public Iterator<Username> list() throws UsersRepositoryException;

    public boolean supportVirtualHosting() throws UsersRepositoryException;

    default public Username getUsername(MailAddress mailAddress) throws UsersRepositoryException {
        if (this.supportVirtualHosting()) {
            return Username.of((String)mailAddress.asString());
        }
        return Username.of((String)mailAddress.getLocalPart());
    }

    public MailAddress getMailAddressFor(Username var1) throws UsersRepositoryException;

    public boolean isAdministrator(Username var1) throws UsersRepositoryException;

    public boolean isReadOnly();

    default public void assertValid(Username username) throws UsersRepositoryException {
        if (username.getDomainPart().isPresent() != this.supportVirtualHosting()) {
            throw new UsersRepositoryException(username.asString() + " username candidate do not match the virtualHosting strategy");
        }
    }
}

