/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.tester;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.james.jspf.tester.DNSTestingServer;
import org.jvyaml.Constructor;
import org.jvyaml.DefaultYAMLFactory;
import org.xbill.DNS.TextParseException;

public class DNSTestingServerLauncher {
    private static final char CHAR_TESTNAME = 't';
    private static final char CHAR_FILE = 'f';
    private static final char CHAR_PORT = 'p';
    private static final char CHAR_IP = 'i';
    private static final String CMD_IP = "ip";
    private static final String CMD_PORT = "port";
    private static final String CMD_FILE = "file";
    private static final String CMD_TESTNAME = "test";

    public static void main(String[] args) {
        String ip = null;
        String port = null;
        String file = null;
        String test = null;
        Options options = DNSTestingServerLauncher.generateOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            ip = line.getOptionValue('i');
            port = line.getOptionValue('p');
            file = line.getOptionValue('f');
            test = line.getOptionValue('t');
            if (ip == null) {
                ip = "0.0.0.0";
            }
            if (port == null) {
                port = "53";
            }
            if (file != null && test != null) {
                FileInputStream is = new FileInputStream(file);
                if (is != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    DefaultYAMLFactory fact = new DefaultYAMLFactory();
                    Constructor ctor = fact.createConstructor(fact.createComposer(fact.createParser(fact.createScanner((Reader)br)), fact.createResolver()));
                    boolean found = false;
                    HashMap zonedata = new HashMap();
                    HashMap testMap = null;
                    while (ctor.checkData() && !found) {
                        Object o = ctor.getData();
                        if (!(o instanceof HashMap) || !test.equals((testMap = (HashMap)o).get("description")) && !"ALL".equalsIgnoreCase(test)) continue;
                        found = true;
                        DNSTestingServerLauncher.loadZoneData(testMap, zonedata);
                    }
                    if (found) {
                        DNSTestingServer testingServer = new DNSTestingServer(ip, port);
                        testingServer.setData(zonedata);
                        System.out.println("Listening on " + ip + ":" + port);
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(1000L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    throw new RuntimeException("Unable to find a <" + test + "> section in the passed file.");
                }
                throw new RuntimeException("Unable to load the file: " + file);
            }
            System.out.println("Missing required parameter.");
            DNSTestingServerLauncher.usage();
        }
        catch (ParseException e) {
            DNSTestingServerLauncher.usage();
        }
        catch (RuntimeException e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
            DNSTestingServerLauncher.usage();
        }
        catch (TextParseException e) {
            System.out.println("Parsing Error: " + e.getMessage());
            e.printStackTrace();
            DNSTestingServerLauncher.usage();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
            e.printStackTrace();
            DNSTestingServerLauncher.usage();
        }
    }

    private static void loadZoneData(HashMap testMap, HashMap zonedata) {
        HashMap loadedZoneData = (HashMap)testMap.get("zonedata");
        Set keys = loadedZoneData.keySet();
        for (String hostname : keys) {
            String lowercase = hostname.toLowerCase(Locale.US);
            if (zonedata.containsKey(lowercase)) {
                System.err.println("Replace zone entry for " + lowercase + " to " + loadedZoneData.get(hostname));
            }
            zonedata.put(lowercase, loadedZoneData.get(hostname));
        }
    }

    private static void usage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("DNSTestingServerLauncher", DNSTestingServerLauncher.generateOptions(), true);
        System.exit(255);
    }

    private static Options generateOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)CMD_IP);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)CMD_IP);
        OptionBuilder.withDescription((String)"Listening IP (default: 0.0.0.0 for every IP)");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)CMD_PORT);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)CMD_PORT);
        OptionBuilder.withDescription((String)"Listening port (default: 53)");
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)CMD_FILE);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withDescription((String)"YML file name");
        OptionBuilder.withArgName((String)CMD_FILE);
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)CMD_TESTNAME);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Test name");
        OptionBuilder.withArgName((String)CMD_TESTNAME);
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((char)'t'));
        return options;
    }
}

