/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.jsieve.commands;

import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.ActionDiscard;
import org.apache.jsieve.mail.MailAdapter;

/**
 * Class Discard implements the Discard Command as defined in RFC 3028, section
 * 4.5.
 */
public class Discard extends AbstractActionCommand {

    /**
     * Constructor for Discard.
     */
    public Discard() {
        super();
    }

    /**
     * <p>
     * Discard silently discards a Mail by cancelling the implicit keep as
     * specified in RFC 3028, Section 4.5.
     * </p>
     * <p>
     * 
     * @see org.apache.jsieve.commands.AbstractCommand#executeBasic(MailAdapter,
     *      Arguments, Block, SieveContext)
     *      </p>
     */
    protected Object executeBasic(MailAdapter mail, Arguments arguments,
            Block block, SieveContext context) throws SieveException {
        // Just cancels the implicit keep
        // See http://tools.ietf.org/html/rfc5228#section-4.4
        context.getCommandStateManager().setImplicitKeep(false);

        mail.addAction(new ActionDiscard());

        return null;
    }

}
