/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;
import org.apache.tika.io.IOUtils;
import org.apache.tika.parser.ner.NERecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNLPNameFinder
implements NERecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNLPNameFinder.class);
    private final String nameType;
    private final Set<String> nameTypes;
    private NameFinderME nameFinder;
    private boolean available;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPNameFinder(String nameType, String nerModelPath) {
        this.nameTypes = Collections.singleton(nameType);
        this.nameType = nameType;
        InputStream nerModelStream = this.getClass().getClassLoader().getResourceAsStream(nerModelPath);
        try {
            if (nerModelStream != null) {
                TokenNameFinderModel model = new TokenNameFinderModel(nerModelStream);
                this.nameFinder = new NameFinderME(model);
                this.available = true;
            } else {
                LOG.warn("Couldn't find model from {} using class loader", (Object)nerModelPath);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly(nerModelStream);
        }
        LOG.info("{} NER : Available for service ? {}", (Object)nameType, (Object)this.available);
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return this.nameTypes;
    }

    public static String[] tokenize(String text) {
        return text.trim().replaceAll("(\\s\\s+)", " ").split("\\s");
    }

    @Override
    public synchronized Map<String, Set<String>> recognise(String text) {
        String[] tokens = OpenNLPNameFinder.tokenize(text);
        return this.findNames(tokens);
    }

    public Map<String, Set<String>> findNames(String[] tokens) {
        Span[] nameSpans = this.nameFinder.find(tokens);
        String[] names = Span.spansToStrings((Span[])nameSpans, (String[])tokens);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (names != null && names.length > 0) {
            result.put(this.nameType, new HashSet<String>(Arrays.asList(names)));
        }
        this.nameFinder.clearAdaptiveData();
        return result;
    }
}

