/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.List;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;

final class GridGeometryWrapper
extends GridGeometry {
    private final CoordinateSystem netcdfCS;

    GridGeometryWrapper(CoordinateSystem coordinateSystem) {
        this.netcdfCS = coordinateSystem;
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    public int getTargetDimensions() {
        return this.netcdfCS.getRankRange();
    }

    @Override
    public Axis[] getAxes() throws IOException, DataStoreException {
        List list = this.netcdfCS.getDomain();
        List list2 = this.netcdfCS.getCoordinateAxes();
        int n = list2.size();
        Axis[] axisArray = new Axis[n];
        while (--n >= 0) {
            CoordinateAxis coordinateAxis = (CoordinateAxis)list2.get(n);
            AttributeNames.Dimension dimension = null;
            AxisType axisType = coordinateAxis.getAxisType();
            if (axisType != null) {
                switch (axisType) {
                    case Lon: {
                        dimension = AttributeNames.LONGITUDE;
                        break;
                    }
                    case Lat: {
                        dimension = AttributeNames.LATITUDE;
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        dimension = AttributeNames.VERTICAL;
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        dimension = AttributeNames.TIME;
                    }
                }
            }
            int n2 = 0;
            List list3 = coordinateAxis.getDimensions();
            int[] nArray = new int[list3.size()];
            int[] nArray2 = new int[nArray.length];
            for (Dimension dimension2 : list3) {
                int n3 = list.lastIndexOf(dimension2);
                if (n3 < 0) continue;
                nArray[n2] = n3;
                nArray2[n2++] = dimension2.getLength();
            }
            axisArray[n] = new Axis(this, coordinateAxis, dimension, ArraysExt.resize(nArray, n2), ArraysExt.resize(nArray2, n2));
        }
        return axisArray;
    }

    @Override
    protected double coordinateForAxis(Object object, int n, int n2) {
        return object instanceof CoordinateAxis2D ? ((CoordinateAxis2D)object).getCoordValue(n, n2) : Double.NaN;
    }
}

