/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.tika.Tika;

public class ImportFileSystem
implements Command {
    private static Log log = LogFactory.getLog(ImportFileSystem.class);
    private static Tika tika = new Tika();
    private String srcFsPathKey = "srcFsPath";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String file = (String)ctx.get(this.srcFsPathKey);
        Node parent = CommandHelper.getCurrentNode(ctx);
        if (log.isDebugEnabled()) {
            log.debug("importing filesystem from " + file + " to node " + parent);
        }
        if (file == null) {
            throw new CommandException("exception.fspath.is.null");
        }
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException("exception.file.not.found", new String[]{file});
        }
        if (f.isFile()) {
            this.importFile(parent, f);
        } else {
            Node folder = parent.addNode(f.getName(), "nt:folder");
            this.importFolder(folder, f);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFile(Node parentnode, File file) throws RepositoryException, IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(file.lastModified());
            JcrUtils.putFile(parentnode, file.getName(), tika.detect(file), stream, date);
        }
    }

    private void importFolder(Node parentnode, File directory) throws RepositoryException, IOException {
        File[] direntries = directory.listFiles();
        for (int i = 0; i < direntries.length; ++i) {
            File direntry = direntries[i];
            if (direntry.isDirectory()) {
                Node childnode = JcrUtils.getOrAddFolder(parentnode, direntry.getName());
                this.importFolder(childnode, direntry);
                continue;
            }
            this.importFile(parentnode, direntry);
        }
    }

    public String getSrcFsPathKey() {
        return this.srcFsPathKey;
    }

    public void setSrcFsPathKey(String fromKey) {
        this.srcFsPathKey = fromKey;
    }
}

