/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Item;
import javax.jcr.Workspace;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Copy
implements Command {
    private static Log log = LogFactory.getLog(Copy.class);
    private String srcWorkspaceKey = "srcWorkspace";
    private String srcAbsPathKey = "srcAbsPath";
    private String destAbsPathKey = "destAbsPath";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String srcWorkspace = (String)ctx.get(this.srcWorkspaceKey);
        String srcAbsPath = (String)ctx.get(this.srcAbsPathKey);
        String destAbsPath = (String)ctx.get(this.destAbsPathKey);
        Workspace w = CommandHelper.getSession(ctx).getWorkspace();
        if (srcWorkspace == null) {
            srcWorkspace = w.getName();
        }
        if (log.isDebugEnabled()) {
            log.debug("copying node from [" + srcWorkspace + ":" + srcAbsPath + "] to [" + w.getName() + ":" + destAbsPath + "]");
        }
        if (destAbsPath.endsWith("/")) {
            Item source = CommandHelper.getSession(ctx).getItem(srcAbsPath);
            destAbsPath = destAbsPath + source.getName();
        }
        w.copy(srcWorkspace, srcAbsPath, destAbsPath);
        return false;
    }

    public String getDestAbsPathKey() {
        return this.destAbsPathKey;
    }

    public void setDestAbsPathKey(String destAbsPathKey) {
        this.destAbsPathKey = destAbsPathKey;
    }

    public String getSrcAbsPathKey() {
        return this.srcAbsPathKey;
    }

    public void setSrcAbsPathKey(String srcAbsPathKey) {
        this.srcAbsPathKey = srcAbsPathKey;
    }

    public String getSrcWorkspaceKey() {
        return this.srcWorkspaceKey;
    }

    public void setSrcWorkspaceKey(String srcWorkspaceKey) {
        this.srcWorkspaceKey = srcWorkspaceKey;
    }
}

