/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client.iterator;

import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;

public abstract class ClientIterator
extends ClientObject
implements RangeIterator {
    private final RemoteIterator remote;
    private long size;
    private long positionOfBuffer;
    private int positionInBuffer;
    private Object[] buffer;

    public ClientIterator(RemoteIterator remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
        this.size = -2L;
        this.positionOfBuffer = 0L;
        this.positionInBuffer = 0;
        this.buffer = new Object[0];
    }

    @Override
    public long getPosition() {
        return this.positionOfBuffer + (long)this.positionInBuffer;
    }

    @Override
    public long getSize() throws RemoteRuntimeException {
        if (this.size == -2L) {
            try {
                this.size = this.remote.getSize();
            }
            catch (RemoteException e) {
                throw new RemoteRuntimeException(e);
            }
        }
        return this.size;
    }

    @Override
    public void skip(long skipNum) throws NoSuchElementException, RemoteRuntimeException {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("Negative skip is not allowed");
        }
        if (this.buffer == null && skipNum > 0L) {
            throw new NoSuchElementException("Skipped past the last element");
        }
        if ((long)this.positionInBuffer + skipNum <= (long)this.buffer.length) {
            this.positionInBuffer = (int)((long)this.positionInBuffer + skipNum);
        } else {
            try {
                this.remote.skip(skipNum -= (long)(this.buffer.length - this.positionInBuffer));
                this.positionInBuffer = this.buffer.length;
                this.positionOfBuffer += skipNum;
            }
            catch (RemoteException e) {
                throw new RemoteRuntimeException(e);
            }
            catch (NoSuchElementException e) {
                this.buffer = null;
                throw e;
            }
        }
    }

    private void advance() throws RemoteException {
        if (this.buffer != null && this.positionInBuffer == this.buffer.length) {
            this.positionOfBuffer += (long)this.buffer.length;
            this.positionInBuffer = 0;
            this.buffer = this.remote.nextObjects();
            if (this.buffer == null) {
                this.size = this.positionOfBuffer;
            }
        }
    }

    @Override
    public boolean hasNext() throws RemoteRuntimeException {
        try {
            this.advance();
            return this.buffer != null;
        }
        catch (RemoteException e) {
            throw new RemoteRuntimeException(e);
        }
    }

    protected abstract Object getObject(Object var1);

    public Object next() throws NoSuchElementException, RemoteRuntimeException {
        try {
            this.advance();
            if (this.buffer == null) {
                throw new NoSuchElementException("End of iterator reached");
            }
            return this.getObject(this.buffer[this.positionInBuffer++]);
        }
        catch (RemoteException e) {
            throw new RemoteRuntimeException(e);
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

