/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteItem;

public class ClientItem
extends ClientObject
implements Item {
    private Session session;
    private RemoteItem remote;

    public ClientItem(Session session, RemoteItem remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getPath() throws RepositoryException {
        try {
            return this.remote.getPath();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getName() throws RepositoryException {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Item getAncestor(int level) throws RepositoryException {
        try {
            return this.getItem(this.getSession(), this.remote.getAncestor(level));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node getParent() throws RepositoryException {
        try {
            return this.getNode(this.getSession(), this.remote.getParent());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public int getDepth() throws RepositoryException {
        try {
            return this.remote.getDepth();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public boolean isNew() {
        try {
            return this.remote.isNew();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public boolean isModified() {
        try {
            return this.remote.isModified();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public boolean isSame(Item item) throws RepositoryException {
        if (item == null) {
            return false;
        }
        if (this.equals(item)) {
            return true;
        }
        if (this.isNode() == item.isNode()) {
            return this.getPath().equals(item.getPath());
        }
        return false;
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
    }

    @Override
    public void save() throws RepositoryException {
        try {
            this.remote.save();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void refresh(boolean keepChanges) throws RepositoryException {
        try {
            this.remote.refresh(keepChanges);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void remove() throws RepositoryException {
        try {
            this.remote.remove();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

