/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.AccessControlConstants;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlEntryImpl;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccessControlListImpl
implements JackrabbitAccessControlList,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AccessControlListImpl.class);
    private final String jcrPath;
    private final List<AccessControlEntry> entries;
    private final QValueFactory qValueFactory;
    private final NamePathResolver resolver;
    private final String jcrRepGlob;

    public AccessControlListImpl(String jcrPath, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this.jcrPath = jcrPath;
        this.entries = new ArrayList<AccessControlEntry>();
        this.qValueFactory = qValueFactory;
        this.resolver = resolver;
        try {
            this.jcrRepGlob = resolver.getJCRName(P_GLOB);
        }
        catch (NamespaceException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    AccessControlListImpl(NodeState aclNode, String aclPath, NamePathResolver resolver, QValueFactory factory, AccessControlManager acm) throws RepositoryException {
        this(aclPath, resolver, factory);
        NodeEntry entry = (NodeEntry)aclNode.getHierarchyEntry();
        Iterator<NodeEntry> it = entry.getNodeEntries();
        while (it.hasNext()) {
            NodeState aceNode = it.next().getNodeState();
            try {
                PropertyState ps = aceNode.getPropertyState(N_REP_PRINCIPAL_NAME);
                String principalName = ps.getValue().getString();
                Principal principal = AccessControlListImpl.createPrincipal(principalName);
                ps = aceNode.getPropertyState(N_REP_PRIVILEGES);
                QValue[] values = ps.getValues();
                Privilege[] privileges = new Privilege[values.length];
                for (int i = 0; i < values.length; ++i) {
                    privileges[i] = acm.privilegeFromName(values[i].getString());
                }
                Map<Name, QValue> restrictions = null;
                if (aceNode.hasPropertyName(P_GLOB)) {
                    ps = aceNode.getPropertyState(P_GLOB);
                    restrictions = Collections.singletonMap(ps.getName(), ps.getValue());
                }
                boolean isAllow = NT_REP_GRANT_ACE.equals(aceNode.getNodeTypeName());
                AccessControlEntryImpl ace = new AccessControlEntryImpl(principal, privileges, isAllow, restrictions, Collections.EMPTY_MAP, resolver, this.qValueFactory);
                this.entries.add(ace);
            }
            catch (RepositoryException e) {
                log.debug("Fail to create Entry for " + aceNode.getName().toString());
            }
        }
    }

    @Override
    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        return this.entries.toArray(new AccessControlEntry[this.entries.size()]);
    }

    @Override
    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.emptyMap());
    }

    @Override
    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!this.entries.contains(ace)) {
            throw new AccessControlException("Entry not present in this list");
        }
        this.entries.remove(ace);
    }

    @Override
    public String getPath() {
        return this.jcrPath;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, Collections.emptyMap());
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) throws AccessControlException, RepositoryException {
        Map<Name, QValue> rs = this.createRestrictions(restrictions);
        Map<Name, Iterable<QValue>> mvRs = this.createMvRestrictions(mvRestrictions);
        AccessControlEntry entry = this.createEntry(principal, privileges, isAllow, rs, mvRs);
        return this.entries.add(entry);
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, restrictions, Collections.EMPTY_MAP);
    }

    @Override
    public String[] getRestrictionNames() throws RepositoryException {
        return new String[]{this.jcrRepGlob};
    }

    @Override
    public int getRestrictionType(String restrictionName) throws RepositoryException {
        if (!this.jcrRepGlob.equals(restrictionName)) {
            return 0;
        }
        return 1;
    }

    @Override
    public void orderBefore(AccessControlEntry srcEntry, AccessControlEntry destEntry) throws AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("not yet implemented");
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlListImpl) {
            AccessControlListImpl acl = (AccessControlListImpl)obj;
            return this.jcrPath.equals(acl.jcrPath) && this.entries.equals(acl.entries);
        }
        return false;
    }

    private AccessControlEntry createEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<Name, QValue> restrictions, Map<Name, Iterable<QValue>> mvRestrictions) throws RepositoryException {
        return new AccessControlEntryImpl(principal, privileges, isAllow, restrictions, mvRestrictions, this.resolver, this.qValueFactory);
    }

    private Map<Name, QValue> createRestrictions(Map<String, Value> restrictions) throws RepositoryException {
        HashMap<Name, QValue> rs = new HashMap<Name, QValue>(restrictions.size());
        for (String restName : restrictions.keySet()) {
            Value v = restrictions.get(restName);
            rs.put(this.resolver.getQName(restName), ValueFormat.getQValue(v, this.resolver, this.qValueFactory));
        }
        return rs;
    }

    private Map<Name, Iterable<QValue>> createMvRestrictions(Map<String, Value[]> restrictions) throws RepositoryException {
        HashMap<Name, Iterable<QValue>> rs = new HashMap<Name, Iterable<QValue>>(restrictions.size());
        for (String restName : restrictions.keySet()) {
            QValue[] qvs = ValueFormat.getQValues(restrictions.get(restName), this.resolver, this.qValueFactory);
            rs.put(this.resolver.getQName(restName), Arrays.asList(qvs));
        }
        return rs;
    }

    private static Principal createPrincipal(final String name) {
        return new Principal(){

            @Override
            public String getName() {
                return name;
            }
        };
    }
}

