/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.JackrabbitNode;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.AddMixinOperation;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeTypeInstanceHandler;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.RemoveMixinOperation;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.session.AddNodeOperation;
import org.apache.jackrabbit.core.session.NodeNameNormalizer;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl
extends ItemImpl
implements Node,
JackrabbitNode {
    private static Logger log = LoggerFactory.getLogger(NodeImpl.class);
    protected static final short CREATED = 0;
    private final AbstractNodeData data;

    protected NodeImpl(ItemManager itemMgr, SessionContext sessionContext, AbstractNodeData data) {
        super(itemMgr, sessionContext, data);
        this.data = data;
        NodeTypeRegistry ntReg = sessionContext.getNodeTypeRegistry();
        NodeState state = data.getNodeState();
        if (!ntReg.isRegistered(state.getNodeTypeName())) {
            log.warn("Fallback to nt:unstructured due to unknown node type '" + state.getNodeTypeName() + "' of " + this);
            data.getNodeState().setNodeTypeName(NameConstants.NT_UNSTRUCTURED);
        }
        ArrayList<Name> unknown = null;
        for (Name mixinName : state.getMixinTypeNames()) {
            if (ntReg.isRegistered(mixinName)) continue;
            if (unknown == null) {
                unknown = new ArrayList<Name>();
            }
            unknown.add(mixinName);
            log.warn("Ignoring unknown mixin type '" + mixinName + "' of " + this);
        }
        if (unknown != null) {
            HashSet<Name> known = new HashSet<Name>(state.getMixinTypeNames());
            known.removeAll(unknown);
            state.setMixinTypeNames(known);
        }
    }

    NodeState getNodeState() {
        return this.data.getNodeState();
    }

    protected PropertyId resolveRelativePropertyPath(String relPath) throws RepositoryException {
        Path p = this.resolveRelativePath(relPath);
        return this.getPropertyId(p);
    }

    protected NodeId resolveRelativeNodePath(String relPath) throws RepositoryException {
        Path p = this.resolveRelativePath(relPath);
        return this.getNodeId(p);
    }

    private Path resolveRelativePath(String relPath) throws RepositoryException {
        try {
            return this.sessionContext.getQPath(relPath);
        }
        catch (NameException e) {
            throw new RepositoryException("Failed to resolve path " + relPath + " relative to " + this, e);
        }
    }

    private NodeId getNodeId(Path p) throws RepositoryException {
        if (p.getLength() == 1 && p.denotesName()) {
            ChildNodeEntry cne = this.data.getNodeState().getChildNodeEntry(p.getName(), p.getNormalizedIndex());
            if (cne != null) {
                return cne.getId();
            }
            return null;
        }
        try {
            p = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), p, true);
        }
        catch (RepositoryException re) {
            return null;
        }
        return this.sessionContext.getHierarchyManager().resolveNodePath(p);
    }

    private PropertyId getPropertyId(Path p) throws RepositoryException {
        if (p.getLength() == 1 && p.denotesName()) {
            NodeState thisState = this.data.getNodeState();
            if (p.getIndex() == 0 && thisState.hasPropertyName(p.getName())) {
                return new PropertyId(thisState.getNodeId(), p.getName());
            }
            return null;
        }
        try {
            p = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), p, true);
        }
        catch (RepositoryException re) {
            return null;
        }
        return this.sessionContext.getHierarchyManager().resolvePropertyPath(p);
    }

    protected boolean hasPendingChanges() throws RepositoryException {
        if (this.isTransient()) {
            return true;
        }
        return !this.stateMgr.getDescendantTransientItemStates(this.id).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        AbstractNodeData abstractNodeData = this.data;
        synchronized (abstractNodeData) {
            if (!this.isTransient()) {
                try {
                    NodeState transientState = this.stateMgr.createTransientNodeState((NodeState)this.stateMgr.getItemState(this.getId()), 2);
                    this.data.setState(transientState);
                }
                catch (ItemStateException ise) {
                    String msg = "failed to create transient state";
                    log.debug(msg);
                    throw new RepositoryException(msg, ise);
                }
            }
            return this.getItemState();
        }
    }

    protected PropertyImpl getOrCreateProperty(String name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        try {
            return this.getOrCreateProperty(this.sessionContext.getQName(name), type, multiValued, exactTypeMatch, status);
        }
        catch (NameException e) {
            throw new RepositoryException("invalid property name: " + name, e);
        }
    }

    protected synchronized PropertyImpl getOrCreateProperty(Name name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        status.clear();
        if (this.isNew() && !this.hasProperty(name)) {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(name, type, multiValued, exactTypeMatch);
            PropertyImpl prop = this.createChildProperty(name, type, def);
            status.set(0);
            return prop;
        }
        PropertyId propId = new PropertyId(this.getNodeId(), name);
        try {
            return (PropertyImpl)this.itemMgr.getItem(propId);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(name.toString());
        }
        catch (ItemNotFoundException e) {
            PropertyImpl prop;
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(name, type, multiValued, exactTypeMatch);
            if (this.stateMgr.hasTransientItemStateInAttic(propId)) {
                try {
                    this.stateMgr.disposeTransientItemStateInAttic(this.stateMgr.getAttic().getItemState(propId));
                }
                catch (ItemStateException ise) {
                    throw new RepositoryException(ise);
                }
                prop = (PropertyImpl)this.itemMgr.getItem(propId);
                PropertyState state = (PropertyState)prop.getOrCreateTransientItemState();
                state.setMultiValued(multiValued);
                state.setType(type);
                this.getNodeState().addPropertyName(name);
            } else {
                prop = this.createChildProperty(name, type, def);
            }
            status.set(0);
            return prop;
        }
    }

    protected synchronized PropertyImpl createChildProperty(Name name, int type, PropertyDefinitionImpl def) throws RepositoryException {
        PropertyState propState;
        try {
            QPropertyDefinition propDef = def.unwrap();
            if (def.getRequiredType() != 0) {
                type = def.getRequiredType();
            }
            propState = this.stateMgr.createTransientPropertyState(this.getNodeId(), name, 4);
            propState.setType(type);
            propState.setMultiValued(propDef.isMultiple());
            String userId = this.sessionContext.getSessionImpl().getUserID();
            new NodeTypeInstanceHandler(userId).setDefaultValues(propState, this.data.getNodeState(), propDef);
        }
        catch (ItemStateException ise) {
            String msg = "failed to add property " + name + " to " + this;
            log.debug(msg);
            throw new RepositoryException(msg, ise);
        }
        PropertyImpl prop = (PropertyImpl)this.itemMgr.createItemInstance(propState);
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addPropertyName(name);
        return prop;
    }

    protected synchronized NodeImpl createChildNode(Name name, NodeTypeImpl nodeType, NodeId id) throws RepositoryException {
        NodeImpl node;
        NodeState nodeState = this.stateMgr.createTransientNodeState(id, nodeType.getQName(), this.getNodeId(), 4);
        try {
            node = (NodeImpl)this.itemMgr.createItemInstance(nodeState);
        }
        catch (RepositoryException re) {
            this.stateMgr.disposeTransientItemState(nodeState);
            throw re;
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addChildNodeEntry(name, nodeState.getNodeId());
        for (PropertyDefinition propertyDefinition : nodeType.getAutoCreatedPropertyDefinitions()) {
            PropertyDefinitionImpl pd = (PropertyDefinitionImpl)propertyDefinition;
            node.createChildProperty(pd.unwrap().getName(), pd.getRequiredType(), pd);
        }
        for (ItemDefinition itemDefinition : nodeType.getAutoCreatedNodeDefinitions()) {
            NodeDefinitionImpl nd = (NodeDefinitionImpl)itemDefinition;
            node.createChildNode(nd.unwrap().getName(), (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
        }
        return node;
    }

    protected void renameChildNode(Name oldName, int index, NodeId id, Name newName) throws RepositoryException {
        this.renameChildNode(id, newName, false);
    }

    protected void renameChildNode(NodeId id, Name newName, boolean replace) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (replace) {
            thisState.replaceChildNodeEntry(id, newName, id);
        } else {
            thisState.renameChildNodeEntry(id, newName);
        }
    }

    protected void removeChildProperty(Name propName) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (!thisState.removePropertyName(propName)) {
            String msg = "failed to remove property " + propName + " of " + this;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
        this.itemMgr.getItem(propId).setRemoved();
    }

    protected void removeChildNode(NodeId childId) throws RepositoryException {
        NodeState thisState;
        block5: {
            thisState = (NodeState)this.getOrCreateTransientItemState();
            ChildNodeEntry entry = thisState.getChildNodeEntry(childId);
            if (entry == null) {
                String msg = "failed to remove child " + childId + " of " + this;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            try {
                NodeImpl childNode = this.itemMgr.getNode(childId, this.getNodeId());
                childNode.onRemove(this.getNodeId());
            }
            catch (ItemNotFoundException e) {
                SessionItemStateManager ism;
                boolean ignoreError = false;
                if (this.sessionContext.getSessionImpl().autoFixCorruptions() && !(ism = this.sessionContext.getItemStateManager()).hasItemState(childId)) {
                    log.warn("Node " + childId + " not found, ignore", e);
                    ignoreError = true;
                }
                if (ignoreError) break block5;
                throw e;
            }
        }
        if (!thisState.removeChildNodeEntry(childId)) {
            String msg = "failed to remove child " + childId + " of " + this;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
    }

    protected void onRedefine(QNodeDefinition def) throws RepositoryException {
        NodeDefinitionImpl newDef = this.sessionContext.getNodeTypeManager().getNodeDefinition(def);
        this.getOrCreateTransientItemState();
        this.data.setDefinition(newDef);
    }

    protected void onRemove(NodeId parentId) throws RepositoryException {
        AbstractCollection tmp;
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (thisState.isShareable() && thisState.removeShare(parentId) > 0) {
            this.data.setStatus(3);
            this.itemMgr.itemInvalidated(this.id, this.data);
            return;
        }
        if (thisState.hasChildNodeEntries()) {
            tmp = new ArrayList<ChildNodeEntry>(thisState.getChildNodeEntries());
            for (int i = ((ArrayList)tmp).size() - 1; i >= 0; --i) {
                NodeId childId;
                block7: {
                    ChildNodeEntry entry = (ChildNodeEntry)((ArrayList)tmp).get(i);
                    childId = entry.getId();
                    try {
                        NodeImpl childNode = this.itemMgr.getNode(childId, this.getNodeId(), false);
                        childNode.onRemove(thisState.getNodeId());
                    }
                    catch (ItemNotFoundException e) {
                        SessionItemStateManager ism;
                        boolean ignoreError = false;
                        if (parentId != null && this.sessionContext.getSessionImpl().autoFixCorruptions() && !(ism = this.sessionContext.getItemStateManager()).hasItemState(childId)) {
                            log.warn("Child named " + entry.getName() + " (index " + entry.getIndex() + ", node id " + childId + ") not found when trying to remove " + this.getPath() + " (node id " + this.getNodeId() + ") - ignored", e);
                            ignoreError = true;
                        }
                        if (ignoreError) break block7;
                        throw e;
                    }
                }
                thisState.removeChildNodeEntry(childId);
            }
        }
        tmp = new HashSet<Name>(thisState.getPropertyNames());
        for (Name propName : tmp) {
            thisState.removePropertyName(propName);
            PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
            this.itemMgr.getItem(propId, false).setRemoved();
        }
        thisState.setParentId(null);
        this.setRemoved();
    }

    void setMixinTypesProperty(Set<Name> mixinNames) throws RepositoryException {
        PropertyImpl prop;
        NodeState thisState = this.data.getNodeState();
        if (thisState.hasPropertyName(NameConstants.JCR_MIXINTYPES)) {
            prop = (PropertyImpl)this.itemMgr.getItem(new PropertyId(thisState.getNodeId(), NameConstants.JCR_MIXINTYPES));
        } else {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(NameConstants.JCR_MIXINTYPES, 7, true, true);
            prop = this.createChildProperty(NameConstants.JCR_MIXINTYPES, 7, def);
        }
        if (mixinNames.isEmpty()) {
            this.removeChildProperty(NameConstants.JCR_MIXINTYPES);
            return;
        }
        InternalValue[] vals = new InternalValue[mixinNames.size()];
        Iterator<Name> iter = mixinNames.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            vals[cnt++] = InternalValue.create(iter.next());
        }
        prop.internalSetValue(vals, 7);
    }

    public Set<Name> getMixinTypeNames() {
        return this.data.getNodeState().getMixinTypeNames();
    }

    public EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        try {
            return this.sessionContext.getNodeTypeRegistry().getEffectiveNodeType(this.data.getNodeState().getNodeTypeName(), this.data.getNodeState().getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "Failed to build effective node type for " + this;
            log.debug(msg);
            throw new RepositoryException(msg, ntce);
        }
    }

    protected NodeDefinitionImpl getApplicableChildNodeDefinition(Name nodeName, Name nodeTypeName) throws ConstraintViolationException, RepositoryException {
        NodeTypeManagerImpl ntMgr = this.sessionContext.getNodeTypeManager();
        QNodeDefinition cnd = this.getEffectiveNodeType().getApplicableChildNodeDef(nodeName, nodeTypeName, this.sessionContext.getNodeTypeRegistry());
        return ntMgr.getNodeDefinition(cnd);
    }

    protected PropertyDefinitionImpl getApplicablePropertyDefinition(Name propertyName, int type, boolean multiValued, boolean exactTypeMatch) throws ConstraintViolationException, RepositoryException {
        QPropertyDefinition pd;
        if (exactTypeMatch || type == 0) {
            pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
        } else {
            try {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
            }
            catch (ConstraintViolationException cve) {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, 0, multiValued);
            }
        }
        return this.sessionContext.getNodeTypeManager().getPropertyDefinition(pd);
    }

    @Override
    protected void makePersistent() throws RepositoryException {
        if (!this.isTransient()) {
            log.debug(this + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        NodeState transientState = this.data.getNodeState();
        NodeState localState = this.stateMgr.makePersistent(transientState);
        this.data.setState(localState);
        this.data.setStatus(0);
        if (this.isShareable() && this.data.getPrimaryParentId() == null) {
            this.data.setPrimaryParentId(localState.getParentId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransient(NodeState transientState) throws RepositoryException {
        NodeState thisState = null;
        if (!this.isTransient()) {
            thisState = (NodeState)this.getOrCreateTransientItemState();
            if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
                thisState.setStatus(4);
                this.stateMgr.disconnectTransientItemState(thisState);
            }
            thisState.setParentId(transientState.getParentId());
            thisState.setNodeTypeName(transientState.getNodeTypeName());
        } else {
            AbstractNodeData abstractNodeData = this.data;
            synchronized (abstractNodeData) {
                thisState = this.stateMgr.createTransientNodeState((NodeId)transientState.getId(), transientState.getNodeTypeName(), transientState.getParentId(), 4);
                this.data.setState(thisState);
            }
        }
        thisState.setMixinTypeNames(transientState.getMixinTypeNames());
        thisState.setChildNodeEntries(transientState.getChildNodeEntries());
        thisState.setPropertyNames(transientState.getPropertyNames());
        thisState.setSharedSet(transientState.getSharedSet());
        thisState.setModCount(transientState.getModCount());
    }

    public void addMixin(Name mixinName) throws RepositoryException {
        this.perform(new AddMixinOperation(this, mixinName));
    }

    public void removeMixin(Name mixinName) throws RepositoryException {
        this.perform(new RemoveMixinOperation(this, mixinName));
    }

    public boolean isNodeType(Name ntName) throws RepositoryException {
        Name primary = this.data.getNodeState().getNodeTypeName();
        if (ntName.equals(primary)) {
            return true;
        }
        Set<Name> mixins = this.data.getNodeState().getMixinTypeNames();
        if (mixins.contains(ntName)) {
            return true;
        }
        try {
            NodeTypeRegistry registry = this.sessionContext.getNodeTypeRegistry();
            EffectiveNodeType type = registry.getEffectiveNodeType(primary, mixins);
            return type.includesNodeType(ntName);
        }
        catch (NodeTypeConflictException e) {
            String msg = "Failed to build effective node type for " + this;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
    }

    protected void checkSetProperty() throws VersionException, LockException, RepositoryException {
        int options = 6;
        this.sessionContext.getItemValidator().checkModify(this, options, 0);
    }

    protected Property internalSetProperty(Name name, InternalValue value) throws ValueFormatException, RepositoryException {
        int type = value == null ? 0 : value.getType();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, true, status);
        try {
            if (value == null) {
                prop.internalSetValue(null, type);
            } else {
                prop.internalSetValue(new InternalValue[]{value}, type);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    protected Property internalSetProperty(Name name, InternalValue[] values) throws ValueFormatException, RepositoryException {
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        return this.internalSetProperty(name, values, type);
    }

    protected Property internalSetProperty(Name name, InternalValue[] values, int type) throws ValueFormatException, RepositoryException {
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            prop.internalSetValue(values, type);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public NodeImpl getNode(Name name) throws ItemNotFoundException, RepositoryException {
        return this.getNode(name, 1);
    }

    public NodeImpl getNode(final Name name, final int index) throws ItemNotFoundException, RepositoryException {
        return this.perform(new SessionOperation<NodeImpl>(){

            @Override
            public NodeImpl perform(SessionContext context) throws RepositoryException {
                ChildNodeEntry cne = NodeImpl.this.data.getNodeState().getChildNodeEntry(name, index != 0 ? index : 1);
                if (cne != null) {
                    try {
                        return context.getItemManager().getNode(cne.getId(), NodeImpl.this.getNodeId());
                    }
                    catch (AccessDeniedException e) {
                        throw new ItemNotFoundException();
                    }
                }
                throw new ItemNotFoundException();
            }

            public String toString() {
                return "node.getNode(" + name + "[" + index + "])";
            }
        });
    }

    public boolean hasNode(Name name) throws RepositoryException {
        return this.hasNode(name, 1);
    }

    public boolean hasNode(final Name name, final int index) throws RepositoryException {
        return this.perform(new SessionOperation<Boolean>(){

            @Override
            public Boolean perform(SessionContext context) throws RepositoryException {
                ChildNodeEntry cne = NodeImpl.this.data.getNodeState().getChildNodeEntry(name, index != 0 ? index : 1);
                return cne != null && context.getItemManager().itemExists(cne.getId());
            }

            public String toString() {
                return "node.hasNode(" + name + "[" + index + "])";
            }
        });
    }

    public PropertyImpl getProperty(final Name name) throws ItemNotFoundException, RepositoryException {
        return this.perform(new SessionOperation<PropertyImpl>(){

            @Override
            public PropertyImpl perform(SessionContext context) throws RepositoryException {
                try {
                    return (PropertyImpl)context.getItemManager().getItem(new PropertyId(NodeImpl.this.getNodeId(), name));
                }
                catch (AccessDeniedException ade) {
                    String n = context.getJCRName(name);
                    throw new ItemNotFoundException("Property " + n + " not found");
                }
            }

            public String toString() {
                return "node.getProperty(" + name + ")";
            }
        });
    }

    public boolean hasProperty(final Name name) throws RepositoryException {
        return this.perform(new SessionOperation<Boolean>(){

            @Override
            public Boolean perform(SessionContext context) throws RepositoryException {
                return NodeImpl.this.data.getNodeState().hasPropertyName(name) && context.getItemManager().itemExists(new PropertyId(NodeImpl.this.getNodeId(), name));
            }

            public String toString() {
                return "node.hasProperty(" + name + ")";
            }
        });
    }

    public synchronized NodeImpl addNode(Name nodeName, Name nodeTypeName, NodeId id) throws RepositoryException {
        NodeDefinitionImpl def;
        this.sanityCheck();
        Path nodePath = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), nodeName, true);
        NodeTypeImpl nt = null;
        if (nodeTypeName != null) {
            nt = this.sessionContext.getNodeTypeManager().getNodeType(nodeTypeName);
            if (nt.isMixin()) {
                throw new ConstraintViolationException("Unable to add a node with a mixin node type: " + this.sessionContext.getJCRName(nodeTypeName));
            }
            if (nt.isAbstract()) {
                throw new ConstraintViolationException("Unable to add a node with an abstract node type: " + this.sessionContext.getJCRName(nodeTypeName));
            }
            this.sessionContext.getAccessManager().checkPermission(nodePath, 128);
        }
        try {
            def = this.getApplicableChildNodeDefinition(nodeName, nodeTypeName);
        }
        catch (RepositoryException e) {
            throw new ConstraintViolationException("No child node definition for " + this.sessionContext.getJCRName(nodeName) + " found in " + this, e);
        }
        if (nt == null) {
            nt = (NodeTypeImpl)def.getDefaultPrimaryType();
        }
        NodeNameNormalizer.check(nodeName);
        NodeState thisState = this.data.getNodeState();
        ChildNodeEntry cne = thisState.getChildNodeEntry(nodeName, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException("This node already exists: " + this.itemMgr.safeGetJCRPath(nodePath));
            }
            NodeImpl existing = this.itemMgr.getNode(cne.getId(), this.getNodeId());
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same-name siblings not allowed for " + existing);
            }
        }
        int options = 406;
        this.sessionContext.getItemValidator().checkModify(this, options, 0);
        return this.createChildNode(nodeName, nt, id);
    }

    public PropertyImpl setProperty(Name name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values, type, true);
    }

    public PropertyImpl setProperty(Name name, Value value) throws RepositoryException {
        return this.sessionContext.getSessionState().perform(new SetPropertyOperation(name, value, false));
    }

    @Override
    public Name getQName() throws RepositoryException {
        HierarchyManager hierMgr = this.sessionContext.getHierarchyManager();
        Name name = !this.isShareable() ? hierMgr.getName(this.id) : hierMgr.getName(this.getNodeId(), this.getParentId());
        return name;
    }

    public NodeId getNodeId() {
        return (NodeId)this.id;
    }

    public Name getPrimaryNodeTypeName() {
        return this.data.getNodeState().getNodeTypeName();
    }

    public boolean isAccessControllable() throws RepositoryException {
        return this.data.getNodeState().hasChildNodeEntry(NameConstants.REP_POLICY, 1) && this.isNodeType(NameConstants.REP_ACCESS_CONTROLLABLE);
    }

    public synchronized void orderBefore(Path.Element srcName, Path.Element dstName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.sanityCheck();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("child node ordering not supported on " + this);
        }
        if (srcName.equals(dstName)) {
            return;
        }
        if (!this.hasNode(srcName.getName(), srcName.getIndex())) {
            String name;
            try {
                Path.Element[] path = new Path.Element[]{srcName};
                name = this.sessionContext.getJCRPath(new PathBuilder(path).getPath());
            }
            catch (NameException e) {
                name = srcName.toString();
            }
            catch (NamespaceException e) {
                name = srcName.toString();
            }
            throw new ItemNotFoundException(this + " has no child node with name " + name);
        }
        if (dstName != null && !this.hasNode(dstName.getName(), dstName.getIndex())) {
            String name;
            try {
                Path.Element[] path = new Path.Element[]{dstName};
                name = this.sessionContext.getJCRPath(new PathBuilder(path).getPath());
            }
            catch (NameException e) {
                name = dstName.toString();
            }
            catch (NamespaceException e) {
                name = dstName.toString();
            }
            throw new ItemNotFoundException(this + " has no child node with name " + name);
        }
        int options = 22;
        this.sessionContext.getItemValidator().checkModify(this, options, 0);
        AccessManager acMgr = this.sessionContext.getAccessManager();
        PathBuilder pb = new PathBuilder(this.getPrimaryPath());
        pb.addLast(srcName.getName(), srcName.getIndex());
        Path childPath = pb.getPath();
        if (!acMgr.isGranted(childPath, 4096)) {
            String msg = "Not allowed to reorder child node " + this.sessionContext.getJCRPath(childPath) + ".";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(this.data.getNodeState().getChildNodeEntries());
        int srcInd = -1;
        int destInd = -1;
        for (int i = 0; i < list.size(); ++i) {
            ChildNodeEntry entry = list.get(i);
            if (srcInd == -1 && entry.getName().equals(srcName.getName()) && (entry.getIndex() == srcName.getIndex() || srcName.getIndex() == 0 && entry.getIndex() == 1)) {
                srcInd = i;
            }
            if (destInd == -1 && dstName != null) {
                if (!entry.getName().equals(dstName.getName()) || entry.getIndex() != dstName.getIndex() && (dstName.getIndex() != 0 || entry.getIndex() != 1)) continue;
                destInd = i;
                if (srcInd == -1) continue;
                break;
            }
            if (srcInd != -1) break;
        }
        if (destInd == -1 ? srcInd == list.size() - 1 : destInd - srcInd == 1) {
            return;
        }
        if (destInd == -1) {
            list.add(list.remove(srcInd));
        } else if (srcInd < destInd) {
            list.add(destInd, list.get(srcInd));
            list.remove(srcInd);
        } else {
            list.add(destInd, list.remove(srcInd));
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setChildNodeEntries(list);
    }

    public synchronized NodeImpl replaceChildNode(NodeId id, Name nodeName, Name nodeTypeName, Name[] mixinNames) throws ItemNotFoundException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.sanityCheck();
        Node existing = (Node)((Object)this.itemMgr.getItem(id));
        NodeState state = this.data.getNodeState();
        ChildNodeEntry cneExisting = state.getChildNodeEntry(id);
        if (cneExisting == null) {
            throw new ItemNotFoundException(this + ": no child node entry with id " + id);
        }
        ArrayList<ChildNodeEntry> cneList = new ArrayList<ChildNodeEntry>(state.getChildNodeEntries());
        existing.remove();
        NodeImpl node = this.addNode(nodeName, nodeTypeName, id);
        if (mixinNames != null) {
            for (Name mixinName : mixinNames) {
                node.addMixin(mixinName);
            }
        }
        state = this.data.getNodeState();
        if (cneExisting.getName().equals(nodeName)) {
            state.setChildNodeEntries(cneList);
        } else {
            state.removeAllChildNodeEntries();
            for (ChildNodeEntry cne : cneList) {
                if (cne.getId().equals(id)) {
                    state.addChildNodeEntry(nodeName, id);
                    continue;
                }
                state.addChildNodeEntry(cne.getName(), cne.getId());
            }
        }
        return node;
    }

    public synchronized NodeImpl clone(NodeImpl src, Name name) throws ItemExistsException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeDefinitionImpl def;
        Path nodePath;
        try {
            nodePath = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), name, true);
        }
        catch (MalformedPathException e) {
            String msg = "internal error: invalid path " + this;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        int options = 22;
        this.sessionContext.getItemValidator().checkModify(this, options, 0);
        try {
            def = this.getApplicableChildNodeDefinition(name, null);
        }
        catch (RepositoryException re) {
            String msg = "no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, re);
        }
        NodeState thisState = this.data.getNodeState();
        ChildNodeEntry cne = thisState.getChildNodeEntry(name, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
            NodeId newId = cne.getId();
            if (!((NodeImpl)this.itemMgr.getItem(newId)).getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
        }
        NodeId parentId = this.getNodeId();
        src.addShareParent(parentId);
        NodeId srcId = src.getNodeId();
        thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addChildNodeEntry(name, srcId);
        return this.itemMgr.getNode(srcId, parentId);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public String getName() throws RepositoryException {
        return this.perform(new SessionOperation<String>(){

            @Override
            public String perform(SessionContext context) throws RepositoryException {
                NodeId parentId = NodeImpl.this.data.getNodeState().getParentId();
                if (parentId == null) {
                    return "";
                }
                Name name = !NodeImpl.this.isShareable() ? context.getHierarchyManager().getName(NodeImpl.this.id) : context.getHierarchyManager().getName(NodeImpl.this.getNodeId(), parentId);
                return context.getJCRName(name);
            }

            public String toString() {
                return "node.getName()";
            }
        });
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit(this);
    }

    @Override
    public Node getParent() throws RepositoryException {
        return this.perform(new SessionOperation<Node>(){

            @Override
            public Node perform(SessionContext context) throws RepositoryException {
                NodeId parentId = NodeImpl.this.getParentId();
                if (parentId != null) {
                    return (Node)((Object)context.getItemManager().getItem(parentId));
                }
                throw new ItemNotFoundException("Root node doesn't have a parent");
            }

            public String toString() {
                return "node.getParent()";
            }
        });
    }

    @Override
    public Node addNode(String relPath) throws RepositoryException {
        return this.addNodeWithUuid(relPath, null, null);
    }

    @Override
    public Node addNode(String relPath, String nodeTypeName) throws RepositoryException {
        return this.addNodeWithUuid(relPath, nodeTypeName, null);
    }

    public Node addNodeWithUuid(String relPath, String uuid) throws RepositoryException {
        return this.addNodeWithUuid(relPath, null, uuid);
    }

    public Node addNodeWithUuid(String relPath, String nodeTypeName, String uuid) throws RepositoryException {
        return this.perform(new AddNodeOperation(this, relPath, nodeTypeName, uuid));
    }

    @Override
    public void orderBefore(String srcName, String destName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        Path.Element beforeName;
        Path.Element insertName;
        try {
            Path p = this.sessionContext.getQPath(srcName);
            if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                throw new RepositoryException("invalid name: " + srcName);
            }
            insertName = p.getNameElement();
        }
        catch (NameException e) {
            String msg = "invalid name: " + srcName;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
        if (destName != null) {
            try {
                Path p = this.sessionContext.getQPath(destName);
                if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                    throw new RepositoryException("invalid name: " + destName);
                }
                beforeName = p.getNameElement();
            }
            catch (NameException e) {
                String msg = "invalid name: " + destName;
                log.debug(msg);
                throw new RepositoryException(msg, e);
            }
        } else {
            beforeName = null;
        }
        this.orderBefore(insertName, beforeName);
    }

    @Override
    public Property setProperty(String name, Value[] values) throws RepositoryException {
        return this.setProperty(this.getQName(name), values, this.getType(values), false);
    }

    @Override
    public Property setProperty(String name, Value[] values, int type) throws RepositoryException {
        return this.setProperty(this.getQName(name), values, type, true);
    }

    @Override
    public Property setProperty(String name, String[] strings) throws RepositoryException {
        Value[] values = this.getValues(strings, 1);
        return this.setProperty(this.getQName(name), values, 1, false);
    }

    @Override
    public Property setProperty(String name, String[] values, int type) throws RepositoryException {
        Value[] converted = this.getValues(values, type);
        return this.setProperty(this.sessionContext.getQName(name), converted, type, true);
    }

    @Override
    public Property setProperty(String name, String value) throws RepositoryException {
        if (value != null) {
            return this.setProperty(name, this.getValueFactory().createValue(value));
        }
        return this.setProperty(name, (Value)null);
    }

    @Override
    public Property setProperty(String name, String value, int type) throws RepositoryException {
        if (value != null) {
            return this.setProperty(name, this.getValueFactory().createValue(value, type), type);
        }
        return this.setProperty(name, (Value)null, type);
    }

    @Override
    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        if (value != null && value.getType() != type) {
            value = ValueHelper.convert(value, type, this.getValueFactory());
        }
        return this.sessionContext.getSessionState().perform(new SetPropertyOperation(this.sessionContext.getQName(name), value, true));
    }

    @Override
    public Property setProperty(String name, Value value) throws RepositoryException {
        return this.sessionContext.getSessionState().perform(new SetPropertyOperation(this.sessionContext.getQName(name), value, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Property setProperty(String name, InputStream value) throws RepositoryException {
        if (value != null) {
            Binary binary = this.getValueFactory().createBinary(value);
            try {
                Property property = this.setProperty(name, this.getValueFactory().createValue(binary));
                return property;
            }
            finally {
                binary.dispose();
            }
        }
        return this.setProperty(name, (Value)null);
    }

    @Override
    public Property setProperty(String name, boolean value) throws RepositoryException {
        return this.setProperty(name, this.getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, double value) throws RepositoryException {
        return this.setProperty(name, this.getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, long value) throws RepositoryException {
        return this.setProperty(name, this.getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, Calendar value) throws RepositoryException {
        if (value != null) {
            try {
                return this.setProperty(name, this.getValueFactory().createValue(value));
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException("Value is not an ISO8601 date: " + value, e);
            }
        }
        return this.setProperty(name, (Value)null);
    }

    @Override
    public Property setProperty(String name, Node value) throws RepositoryException {
        if (value != null) {
            try {
                return this.setProperty(name, this.getValueFactory().createValue(value));
            }
            catch (UnsupportedRepositoryOperationException e) {
                throw new ValueFormatException("Node is not referenceable: " + value, e);
            }
        }
        return this.setProperty(name, (Value)null);
    }

    protected PropertyImpl setProperty(final Name name, final Value[] values, final int type, final boolean enforceType) throws RepositoryException {
        return this.perform(new SessionOperation<PropertyImpl>(){

            @Override
            public PropertyImpl perform(SessionContext context) throws RepositoryException {
                NodeImpl.this.checkSetProperty();
                BitSet status = new BitSet();
                PropertyImpl prop = NodeImpl.this.getOrCreateProperty(name, type, true, enforceType, status);
                try {
                    prop.setValue(values, type);
                }
                catch (RepositoryException re) {
                    if (status.get(0)) {
                        NodeImpl.this.removeChildProperty(name);
                    }
                    throw re;
                }
                return prop;
            }

            public String toString() {
                return "node.setProperty(...)";
            }
        });
    }

    @Override
    public Node getNode(final String relPath) throws RepositoryException {
        return this.perform(new SessionOperation<Node>(){

            @Override
            public Node perform(SessionContext context) throws RepositoryException {
                Path p = NodeImpl.this.resolveRelativePath(relPath);
                NodeId id = NodeImpl.this.getNodeId(p);
                if (id == null) {
                    throw new PathNotFoundException(relPath);
                }
                NodeId parentId = null;
                if (!p.denotesRoot()) {
                    parentId = NodeImpl.this.getNodeId(p.getAncestor(1));
                }
                try {
                    if (parentId != null) {
                        return NodeImpl.this.itemMgr.getNode(id, parentId);
                    }
                    return (NodeImpl)NodeImpl.this.itemMgr.getItem(id);
                }
                catch (AccessDeniedException e) {
                    throw new PathNotFoundException(relPath);
                }
                catch (ItemNotFoundException e) {
                    throw new PathNotFoundException(relPath);
                }
            }

            public String toString() {
                return "node.getNode(" + relPath + ")";
            }
        });
    }

    @Override
    public NodeIterator getNodes() throws RepositoryException {
        return this.perform(new SessionOperation<NodeIterator>(){

            @Override
            public NodeIterator perform(SessionContext context) throws RepositoryException {
                try {
                    return NodeImpl.this.itemMgr.getChildNodes((NodeId)NodeImpl.this.id);
                }
                catch (ItemNotFoundException e) {
                    throw new RepositoryException("Failed to list child nodes of " + NodeImpl.this, e);
                }
                catch (AccessDeniedException e) {
                    throw new RepositoryException("Failed to list child nodes of " + NodeImpl.this, e);
                }
            }

            public String toString() {
                return "node.getNodes()";
            }
        });
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        return this.perform(new SessionOperation<PropertyIterator>(){

            @Override
            public PropertyIterator perform(SessionContext context) throws RepositoryException {
                try {
                    return NodeImpl.this.itemMgr.getChildProperties((NodeId)NodeImpl.this.id);
                }
                catch (ItemNotFoundException e) {
                    throw new RepositoryException("Failed to list properties of " + NodeImpl.this, e);
                }
                catch (AccessDeniedException e) {
                    throw new RepositoryException("Failed to list properties of " + NodeImpl.this, e);
                }
            }

            public String toString() {
                return "node.getProperties()";
            }
        });
    }

    @Override
    public Property getProperty(final String relPath) throws PathNotFoundException, RepositoryException {
        return this.perform(new SessionOperation<Property>(){

            @Override
            public Property perform(SessionContext context) throws RepositoryException {
                PropertyId id = NodeImpl.this.resolveRelativePropertyPath(relPath);
                if (id != null) {
                    try {
                        return (Property)((Object)NodeImpl.this.itemMgr.getItem(id));
                    }
                    catch (ItemNotFoundException e) {
                        throw new PathNotFoundException(relPath);
                    }
                    catch (AccessDeniedException e) {
                        throw new PathNotFoundException(relPath);
                    }
                }
                throw new PathNotFoundException(relPath);
            }

            public String toString() {
                return "node.getProperty(" + relPath + ")";
            }
        });
    }

    @Override
    public boolean hasNode(String relPath) throws RepositoryException {
        this.sanityCheck();
        NodeId id = this.resolveRelativeNodePath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    @Override
    public boolean hasNodes() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildNodes((NodeId)this.id);
    }

    @Override
    public boolean hasProperties() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildProperties((NodeId)this.id);
    }

    @Override
    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        this.sanityCheck();
        try {
            return this.isNodeType(this.sessionContext.getQName(nodeTypeName));
        }
        catch (NameException e) {
            throw new RepositoryException("invalid node type name: " + nodeTypeName, e);
        }
    }

    @Override
    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.sanityCheck();
        return this.sessionContext.getNodeTypeManager().getNodeType(this.data.getNodeState().getNodeTypeName());
    }

    @Override
    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.sanityCheck();
        Set<Name> mixinNames = this.data.getNodeState().getMixinTypeNames();
        if (mixinNames.isEmpty()) {
            return new NodeType[0];
        }
        NodeType[] nta = new NodeType[mixinNames.size()];
        Iterator<Name> iter = mixinNames.iterator();
        int i = 0;
        while (iter.hasNext()) {
            nta[i++] = this.sessionContext.getNodeTypeManager().getNodeType(iter.next());
        }
        return nta;
    }

    @Override
    public void addMixin(String mixinName) throws RepositoryException {
        try {
            this.addMixin(this.sessionContext.getQName(mixinName));
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid mixin type name: " + mixinName, e);
        }
    }

    @Override
    public void removeMixin(String mixinName) throws RepositoryException {
        try {
            this.removeMixin(this.sessionContext.getQName(mixinName));
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid mixin type name: " + mixinName, e);
        }
    }

    @Override
    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        Name ntName = this.sessionContext.getQName(mixinName);
        NodeTypeManagerImpl ntMgr = this.sessionContext.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(ntName);
        if (!mixin.isMixin()) {
            return false;
        }
        int options = 150;
        int permissions = 128;
        if (NameConstants.MIX_VERSIONABLE.equals(ntName) || NameConstants.MIX_SIMPLE_VERSIONABLE.equals(ntName)) {
            permissions |= 0x100;
        }
        if (!this.sessionContext.getItemValidator().canModify(this, options, permissions)) {
            return false;
        }
        Name primaryTypeName = this.data.getNodeState().getNodeTypeName();
        NodeTypeImpl primaryType = ntMgr.getNodeType(primaryTypeName);
        if (primaryType.isDerivedFrom(ntName)) {
            return true;
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            HashSet<Name> mixins = new HashSet<Name>(this.data.getNodeState().getMixinTypeNames());
            EffectiveNodeType entExisting = ntReg.getEffectiveNodeType(primaryTypeName, mixins);
            if (entExisting.includesNodeType(ntName)) {
                return true;
            }
            mixins.add(ntName);
            ntReg.getEffectiveNodeType(primaryTypeName, mixins);
        }
        catch (NodeTypeConflictException ntce) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasProperty(String relPath) throws RepositoryException {
        this.sanityCheck();
        PropertyId id = this.resolveRelativePropertyPath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    @Override
    public PropertyIterator getReferences() throws RepositoryException {
        return this.getReferences(null);
    }

    @Override
    public NodeDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.data.getNodeDefinition();
    }

    @Override
    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectChildNodes((Node)this, namePattern);
    }

    @Override
    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectProperties((Node)this, namePattern);
    }

    @Override
    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        String name = this.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            throw new ItemNotFoundException();
        }
        if (this.hasProperty(name)) {
            return this.getProperty(name);
        }
        if (this.hasNode(name)) {
            return this.getNode(name);
        }
        throw new ItemNotFoundException();
    }

    @Override
    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new UnsupportedRepositoryOperationException();
        }
        return this.getNodeId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        SessionImpl srcSession = null;
        try {
            String relPath;
            RepositoryImpl rep = (RepositoryImpl)this.getSession().getRepository();
            srcSession = rep.createSession(this.sessionContext.getSessionImpl().getSubject(), workspaceName);
            NodeImpl m1 = this;
            while (m1.getDepth() != 0 && !m1.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                m1 = (NodeImpl)m1.getParent();
            }
            if (m1.getDepth() == 0) {
                if (!srcSession.getItemManager().nodeExists(this.getPrimaryPath())) {
                    throw new ItemNotFoundException("Node not found: " + this);
                }
                String string = this.getPath();
                return string;
            }
            Node m2 = srcSession.getNodeByUUID(m1.getUUID());
            if (m1 == this) {
                String string = m2.getPath();
                return string;
            }
            try {
                Path p = m1.getPrimaryPath().computeRelativePath(this.getPrimaryPath());
                relPath = this.sessionContext.getJCRPath(p);
            }
            catch (NameException be) {
                String msg = "internal error: failed to determine relative path";
                log.error(msg, be);
                throw new RepositoryException(msg, be);
            }
            if (!m2.hasNode(relPath)) {
                throw new ItemNotFoundException();
            }
            String string = m2.getNode(relPath).getPath();
            return string;
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    @Override
    public int getIndex() throws RepositoryException {
        this.sanityCheck();
        NodeId parentId = this.getParentId();
        if (parentId == null) {
            return 1;
        }
        try {
            NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
            ChildNodeEntry parentEntry = parent.getChildNodeEntry(this.getNodeId());
            return parentEntry.getIndex();
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to determine index";
            log.error(msg, ise);
            throw new RepositoryException(msg, ise);
        }
    }

    @Override
    public NodeIterator getSharedSet() throws RepositoryException {
        this.sanityCheck();
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        if (!this.isShareable()) {
            list.add(this);
        } else {
            NodeState state = this.data.getNodeState();
            for (NodeId parentId : state.getSharedSet()) {
                list.add(this.itemMgr.getNode(this.getNodeId(), parentId));
            }
        }
        return new NodeIteratorAdapter(list);
    }

    @Override
    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        NodeIterator iter = this.getSharedSet();
        while (iter.hasNext()) {
            iter.nextNode().removeShare();
        }
    }

    @Override
    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.remove();
    }

    boolean isShareable() {
        return this.data.getNodeState().isShareable();
    }

    public NodeId getParentId() {
        return this.data.getParentId();
    }

    boolean hasShareParent(NodeId parentId) {
        return this.data.getNodeState().containsShare(parentId);
    }

    void addShareParent(NodeId parentId) throws RepositoryException {
        if (!this.isShareable()) {
            String msg = this + " is not shareable.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeId srcId = this.getNodeId();
        HierarchyManager hierMgr = this.sessionContext.getHierarchyManager();
        if (parentId.equals(srcId) || hierMgr.isAncestor(srcId, parentId)) {
            String msg = "This would create a share cycle.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState state = this.data.getNodeState();
        if (!state.containsShare(parentId) && (state = (NodeState)this.getOrCreateTransientItemState()).addShare(parentId)) {
            return;
        }
        String msg = "Adding a shareable node twice to the same parent is not supported.";
        log.debug(msg);
        throw new UnsupportedRepositoryOperationException(msg);
    }

    @Override
    public Path getPrimaryPath() throws RepositoryException {
        if (!this.isShareable()) {
            return super.getPrimaryPath();
        }
        NodeId parentId = this.getParentId();
        NodeImpl parentNode = (NodeImpl)this.getParent();
        Path parentPath = parentNode.getPrimaryPath();
        PathBuilder builder = new PathBuilder(parentPath);
        ChildNodeEntry entry = parentNode.getNodeState().getChildNodeEntry(this.getNodeId());
        if (entry == null) {
            String msg = "failed to build path of " + this.id + ": " + parentId + " has no child entry for " + this.id;
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        if (entry.getIndex() == 1) {
            builder.addLast(entry.getName());
        } else {
            builder.addLast(entry.getName(), entry.getIndex());
        }
        return builder.getPath();
    }

    @Override
    public boolean isCheckedOut() throws RepositoryException {
        this.sanityCheck();
        if (this.isNew()) {
            return true;
        }
        try {
            NodeState state = this.getNodeState();
            while (!state.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) {
                NodeId parentId = state.getParentId();
                if (parentId == null) {
                    return true;
                }
                state = (NodeState)this.sessionContext.getItemStateManager().getItemState(parentId);
            }
            PropertyId id = new PropertyId(state.getNodeId(), NameConstants.JCR_ISCHECKEDOUT);
            PropertyState ps = (PropertyState)this.sessionContext.getItemStateManager().getItemState(id);
            InternalValue[] values = ps.getValues();
            if (values == null || values.length != 1) {
                return true;
            }
            return values[0].getBoolean();
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    private VersionManagerImpl getVersionManagerImpl() {
        return this.sessionContext.getWorkspace().getVersionManagerImpl();
    }

    @Override
    public void update(String srcWorkspaceName) throws RepositoryException {
        this.getVersionManagerImpl().update(this, srcWorkspaceName);
    }

    @Override
    @Deprecated
    public Version checkin() throws RepositoryException {
        return this.getVersionManagerImpl().checkin(this.getPath());
    }

    @Deprecated
    public Version checkin(Calendar created) throws RepositoryException {
        return this.getVersionManagerImpl().checkin(this.getPath(), created);
    }

    @Override
    @Deprecated
    public void checkout() throws RepositoryException {
        this.getVersionManagerImpl().checkout(this.getPath());
    }

    @Override
    @Deprecated
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return this.getVersionManagerImpl().merge(this.getPath(), srcWorkspace, bestEffort);
    }

    @Override
    @Deprecated
    public void cancelMerge(Version version) throws RepositoryException {
        this.getVersionManagerImpl().cancelMerge(this.getPath(), version);
    }

    @Override
    @Deprecated
    public void doneMerge(Version version) throws RepositoryException {
        this.getVersionManagerImpl().doneMerge(this.getPath(), version);
    }

    @Override
    @Deprecated
    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restore(this.getPath(), versionName, removeExisting);
    }

    @Override
    @Deprecated
    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restore(this, version, removeExisting);
    }

    @Override
    @Deprecated
    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        if (this.hasNode(relPath)) {
            this.getVersionManagerImpl().restore((NodeImpl)this.getNode(relPath), version, removeExisting);
        } else {
            this.getVersionManagerImpl().restore(this.getPath() + "/" + relPath, version, removeExisting);
        }
    }

    @Override
    @Deprecated
    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restoreByLabel(this.getPath(), versionLabel, removeExisting);
    }

    @Override
    @Deprecated
    public VersionHistory getVersionHistory() throws RepositoryException {
        return this.getVersionManagerImpl().getVersionHistory(this.getPath());
    }

    @Override
    @Deprecated
    public Version getBaseVersion() throws RepositoryException {
        return this.getVersionManagerImpl().getBaseVersion(this.getPath());
    }

    @Override
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.getSession().getWorkspace().getLockManager();
        return lockMgr.lock(this.getPath(), isDeep, isSessionScoped, this.sessionContext.getWorkspace().getConfig().getDefaultLockTimeout(), null);
    }

    @Override
    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.getSession().getWorkspace().getLockManager();
        return lockMgr.getLock(this.getPath());
    }

    @Override
    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.getSession().getWorkspace().getLockManager();
        lockMgr.unlock(this.getPath());
    }

    @Override
    public boolean holdsLock() throws RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.getSession().getWorkspace().getLockManager();
        return lockMgr.holdsLock(this.getPath());
    }

    @Override
    public boolean isLocked() throws RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.getSession().getWorkspace().getLockManager();
        return lockMgr.isLocked(this.getPath());
    }

    protected void checkLock() throws LockException, RepositoryException {
        if (this.isNew()) {
            return;
        }
        this.sessionContext.getWorkspace().getInternalLockManager().checkLock(this);
    }

    @Override
    public String getIdentifier() throws RepositoryException {
        return this.id.toString();
    }

    @Override
    public PropertyIterator getReferences(String name) throws RepositoryException {
        this.sanityCheck();
        try {
            if (this.stateMgr.hasNodeReferences(this.getNodeId())) {
                NodeReferences refs = this.stateMgr.getNodeReferences(this.getNodeId());
                List<PropertyId> idList = refs.getReferences();
                if (name != null) {
                    Name qName;
                    try {
                        qName = this.sessionContext.getQName(name);
                    }
                    catch (NameException e) {
                        throw new RepositoryException("invalid property name: " + name, e);
                    }
                    ArrayList<PropertyId> filteredList = new ArrayList<PropertyId>(idList.size());
                    for (PropertyId propId : idList) {
                        if (!propId.getName().equals(qName)) continue;
                        filteredList.add(propId);
                    }
                    idList = filteredList;
                }
                return new LazyItemIterator(this.sessionContext, idList);
            }
            return PropertyIteratorAdapter.EMPTY;
        }
        catch (ItemStateException e) {
            String msg = "Unable to retrieve REFERENCE properties that refer to " + this.id;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
    }

    @Override
    public PropertyIterator getWeakReferences() throws RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            return PropertyIteratorAdapter.EMPTY;
        }
        Value ref = this.getSession().getValueFactory().createValue(this, true);
        ArrayList<Property> props = new ArrayList<Property>();
        QueryManagerImpl qm = (QueryManagerImpl)this.getSession().getWorkspace().getQueryManager();
        for (Node n : qm.getWeaklyReferringNodes(this)) {
            PropertyIterator it = n.getProperties();
            while (it.hasNext()) {
                Collection<Value> refs;
                Property p = it.nextProperty();
                if (p.getType() != 10 || !(refs = p.isMultiple() ? Arrays.asList(p.getValues()) : Collections.singleton(p.getValue())).contains(ref)) continue;
                props.add(p);
            }
        }
        return new PropertyIteratorAdapter(props);
    }

    @Override
    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        if (name == null) {
            return this.getWeakReferences();
        }
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            return PropertyIteratorAdapter.EMPTY;
        }
        try {
            StringBuilder stmt = new StringBuilder();
            stmt.append("//*[@").append(ISO9075.encode(name));
            stmt.append(" = '").append(this.data.getId()).append("']");
            Query q = this.getSession().getWorkspace().getQueryManager().createQuery(stmt.toString(), "xpath");
            QueryResult result = q.execute();
            ArrayList<Property> l = new ArrayList<Property>();
            NodeIterator nit = result.getNodes();
            while (nit.hasNext()) {
                Node n = nit.nextNode();
                l.add(n.getProperty(name));
            }
            if (l.isEmpty()) {
                return PropertyIteratorAdapter.EMPTY;
            }
            return new PropertyIteratorAdapter(l);
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve WEAKREFERENCE properties that refer to " + this.id;
            log.debug(msg);
            throw new RepositoryException(msg, e);
        }
    }

    @Override
    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectChildNodes((Node)this, nameGlobs);
    }

    @Override
    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectProperties((Node)this, nameGlobs);
    }

    @Override
    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyIterator iter;
        QNodeDefinition nodeDef;
        EffectiveNodeType entAll;
        EffectiveNodeType entOld;
        EffectiveNodeType entNew;
        this.sanityCheck();
        int options = 150;
        this.sessionContext.getItemValidator().checkModify(this, options, 128);
        NodeState state = this.data.getNodeState();
        if (state.getParentId() == null) {
            String msg = "changing the primary type of the root node is not supported";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        Name ntName = this.sessionContext.getQName(nodeTypeName);
        if (ntName.equals(state.getNodeTypeName())) {
            log.debug("Node already has " + nodeTypeName + " as primary node type.");
            return;
        }
        NodeTypeManagerImpl ntMgr = this.sessionContext.getNodeTypeManager();
        NodeTypeImpl nt = ntMgr.getNodeType(ntName);
        if (nt.isMixin()) {
            throw new ConstraintViolationException(nodeTypeName + ": not a primary node type.");
        }
        if (nt.isAbstract()) {
            throw new ConstraintViolationException(nodeTypeName + ": is an abstract node type.");
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            entNew = ntReg.getEffectiveNodeType(ntName);
            entOld = ntReg.getEffectiveNodeType(state.getNodeTypeName());
            entAll = ntReg.getEffectiveNodeType(ntName, state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            throw new ConstraintViolationException(ntce.getMessage());
        }
        try {
            NodeImpl parent = (NodeImpl)this.getParent();
            nodeDef = parent.getApplicableChildNodeDefinition(this.getQName(), ntName).unwrap();
        }
        catch (RepositoryException re) {
            String msg = this + ": no applicable definition found in parent node's node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, re);
        }
        if (!nodeDef.equals(this.itemMgr.getDefinition(state).unwrap())) {
            this.onRedefine(nodeDef);
        }
        HashSet<QItemDefinition> oldDefs = new HashSet<QItemDefinition>(Arrays.asList(entOld.getAllItemDefs()));
        HashSet<QItemDefinition> newDefs = new HashSet<QItemDefinition>(Arrays.asList(entNew.getAllItemDefs()));
        HashSet<QItemDefinition> allDefs = new HashSet<QItemDefinition>(Arrays.asList(entAll.getAllItemDefs()));
        HashSet<QItemDefinition> addedDefs = new HashSet<QItemDefinition>(newDefs);
        addedDefs.removeAll(oldDefs);
        boolean referenceableOld = entOld.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        boolean referenceableNew = entNew.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        if (referenceableOld && !referenceableNew && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException("the new primary type cannot be set as it would render this node 'non-referenceable' while it is still being referenced through at least one property of type REFERENCE");
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setNodeTypeName(ntName);
        this.internalSetProperty(NameConstants.JCR_PRIMARYTYPE, InternalValue.create(ntName));
        HashSet<Name> set = new HashSet<Name>(thisState.getPropertyNames());
        for (Name propName : set) {
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(new PropertyId(thisState.getNodeId(), propName));
                if (allDefs.contains(this.itemMgr.getDefinition(propState).unwrap())) continue;
                try {
                    PropertyImpl prop = (PropertyImpl)this.itemMgr.getItem(propState.getId());
                    if (prop.getDefinition().isProtected()) {
                        this.removeChildProperty(propName);
                        continue;
                    }
                    PropertyDefinitionImpl pdi = this.getApplicablePropertyDefinition(propName, propState.getType(), propState.isMultiValued(), false);
                    if (pdi.getRequiredType() != 0 && pdi.getRequiredType() != propState.getType()) {
                        if (propState.isMultiValued()) {
                            Value[] values = ValueHelper.convert(prop.getValues(), pdi.getRequiredType(), this.getSession().getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(values);
                        } else {
                            Value value = ValueHelper.convert(prop.getValue(), pdi.getRequiredType(), this.getSession().getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(value);
                        }
                    } else {
                        prop.onRedefine(pdi.unwrap());
                    }
                    addedDefs.remove(pdi.unwrap());
                }
                catch (ValueFormatException vfe) {
                    this.removeChildProperty(propName);
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildProperty(propName);
                }
            }
            catch (ItemStateException ise) {
                String msg = propName + ": failed to retrieve property state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(thisState.getChildNodeEntries());
        for (int i = list.size() - 1; i >= 0; --i) {
            ChildNodeEntry entry = list.get(i);
            try {
                NodeState nodeState = (NodeState)this.stateMgr.getItemState(entry.getId());
                if (allDefs.contains(this.itemMgr.getDefinition(nodeState).unwrap())) continue;
                try {
                    NodeImpl node = (NodeImpl)this.itemMgr.getItem(nodeState.getId());
                    if (node.getDefinition().isProtected()) {
                        this.removeChildNode(entry.getId());
                        continue;
                    }
                    NodeDefinitionImpl ndi = this.getApplicableChildNodeDefinition(entry.getName(), nodeState.getNodeTypeName());
                    node.onRedefine(ndi.unwrap());
                    addedDefs.remove(ndi.unwrap());
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildNode(entry.getId());
                }
                continue;
            }
            catch (ItemStateException ise) {
                String msg = entry.getName() + ": failed to retrieve node state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        for (QItemDefinition def : addedDefs) {
            if (!def.isAutoCreated()) continue;
            if (def.definesNode()) {
                NodeDefinitionImpl ndi = ntMgr.getNodeDefinition((QNodeDefinition)def);
                this.createChildNode(def.getName(), (NodeTypeImpl)ndi.getDefaultPrimaryType(), null);
                continue;
            }
            PropertyDefinitionImpl pdi = ntMgr.getPropertyDefinition((QPropertyDefinition)def);
            this.createChildProperty(pdi.unwrap().getName(), pdi.getRequiredType(), pdi);
        }
    }

    @Override
    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    @Override
    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    @Override
    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.isNodeType(NameConstants.MIX_LIFECYCLE)) {
            Node policy = this.getProperty(NameConstants.JCR_LIFECYCLE_POLICY).getNode();
            String state = this.getProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE).getString();
            ArrayList<String> targetStates = new ArrayList<String>();
            if (policy.hasNode("transitions")) {
                Node transitions = policy.getNode("transitions");
                for (Node transition : JcrUtils.getChildNodes(transitions)) {
                    String from = transition.getProperty("from").getString();
                    if (!from.equals(state)) continue;
                    String to = transition.getProperty("to").getString();
                    targetStates.add(to);
                }
            }
            return targetStates.toArray(new String[targetStates.size()]);
        }
        throw new UnsupportedRepositoryOperationException("Only nodes with mixin node type mix:lifecycle may participate in a lifecycle: " + this);
    }

    @Override
    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        for (String target : this.getAllowedLifecycleTransistions()) {
            if (!target.equals(transition)) continue;
            PropertyImpl property = this.getProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE);
            property.internalSetValue(new InternalValue[]{InternalValue.create(target)}, 1);
            property.save();
            return;
        }
        throw new InvalidLifecycleTransitionException("Invalid lifecycle transition \"" + transition + "\" for " + this);
    }

    public void assignLifecyclePolicy(Node policy, String state) throws RepositoryException {
        if (!(policy instanceof NodeImpl) || !((NodeImpl)policy).isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new RepositoryException(policy + " is not referenceable, so it can not be used as a lifecycle policy");
        }
        this.addMixin(NameConstants.MIX_LIFECYCLE);
        this.internalSetProperty(NameConstants.JCR_LIFECYCLE_POLICY, InternalValue.create(((NodeImpl)policy).getNodeId()));
        this.internalSetProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE, InternalValue.create(state));
    }

    @Override
    public void rename(String newName) throws RepositoryException {
        NodeDefinitionImpl newTargetDef;
        Name qName;
        if (this.getDepth() == 0) {
            throw new RepositoryException("Cannot rename the root node");
        }
        try {
            qName = this.sessionContext.getQName(newName);
        }
        catch (NameException e) {
            throw new RepositoryException("invalid node name: " + newName, e);
        }
        NodeImpl parent = (NodeImpl)this.getParent();
        NodeImpl existing = null;
        try {
            existing = parent.getNode(qName);
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same name siblings are not allowed: " + existing);
            }
        }
        catch (AccessDeniedException ade) {
            throw new ItemExistsException();
        }
        catch (ItemNotFoundException ade) {
            // empty catch block
        }
        int options = 406;
        this.sessionContext.getItemValidator().checkRemove(parent, options, 0);
        this.sessionContext.getItemValidator().checkModify(parent, options, 0);
        NodeTypeImpl nt = (NodeTypeImpl)this.getPrimaryNodeType();
        try {
            newTargetDef = parent.getApplicableChildNodeDefinition(qName, nt.getQName());
        }
        catch (RepositoryException re) {
            String msg = this.safeGetJCRPath() + ": no definition found in parent node's node type for renamed node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, re);
        }
        if (existing != null && !newTargetDef.allowsSameNameSiblings()) {
            throw new ItemExistsException("Same name siblings not allowed: " + existing);
        }
        AccessManager acMgr = this.sessionContext.getAccessManager();
        if (!acMgr.isGranted(parent.getPrimaryPath(), qName, 4096)) {
            String msg = "Not allowed to rename node " + this.safeGetJCRPath() + " to " + newName;
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        if (!nt.getName().equals(newTargetDef.getName()) && !acMgr.isGranted(this.getPrimaryPath(), 128)) {
            String msg = "Not allowed to rename node " + this.safeGetJCRPath() + " to " + newName;
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        this.onRedefine(newTargetDef.unwrap());
        parent.renameChildNode(this.getNodeId(), qName, true);
    }

    @Override
    public void setMixins(String[] mixinNames) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyIterator iter;
        EffectiveNodeType entAll;
        EffectiveNodeType entOld;
        EffectiveNodeType entNew;
        this.sanityCheck();
        NodeTypeManagerImpl ntMgr = this.sessionContext.getNodeTypeManager();
        HashSet<Name> newMixins = new HashSet<Name>();
        for (String name : mixinNames) {
            Name qName = this.sessionContext.getQName(name);
            if (!ntMgr.getNodeType(qName).isMixin()) {
                throw new RepositoryException(this.sessionContext.getJCRName(qName) + " is not a mixin node type");
            }
            newMixins.add(qName);
        }
        int permissions = 128;
        if (newMixins.contains(NameConstants.MIX_VERSIONABLE) || newMixins.contains(NameConstants.MIX_SIMPLE_VERSIONABLE)) {
            permissions |= 0x100;
        }
        int options = 150;
        this.sessionContext.getItemValidator().checkModify(this, options, permissions);
        NodeState state = this.data.getNodeState();
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            entNew = ntReg.getEffectiveNodeType(newMixins);
            entOld = ntReg.getEffectiveNodeType(state.getMixinTypeNames());
            entAll = ntReg.getEffectiveNodeType(state.getNodeTypeName(), newMixins);
        }
        catch (NodeTypeConflictException ntce) {
            throw new ConstraintViolationException(ntce.getMessage());
        }
        HashSet<QItemDefinition> addedDefs = new HashSet<QItemDefinition>(Arrays.asList(entNew.getAllItemDefs()));
        addedDefs.removeAll(Arrays.asList(entOld.getAllItemDefs()));
        boolean referenceableOld = this.getEffectiveNodeType().includesNodeType(NameConstants.MIX_REFERENCEABLE);
        boolean referenceableNew = entAll.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        if (referenceableOld && !referenceableNew && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException("the new mixin types cannot be set as it would render this node 'non-referenceable' while it is still being referenced through at least one property of type REFERENCE");
        }
        HashMap<ItemId, ItemDefinitionImpl> oldDefs = new HashMap<ItemId, ItemDefinitionImpl>();
        for (Name name : this.getNodeState().getPropertyNames()) {
            PropertyId id = new PropertyId(this.getNodeId(), name);
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(id);
                oldDefs.put(id, this.itemMgr.getDefinition(propState));
            }
            catch (ItemStateException ise) {
                String msg = name + ": failed to retrieve property state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        for (ChildNodeEntry cne : this.getNodeState().getChildNodeEntries()) {
            try {
                NodeState nodeState = (NodeState)this.stateMgr.getItemState(cne.getId());
                oldDefs.put(cne.getId(), this.itemMgr.getDefinition(nodeState));
            }
            catch (ItemStateException ise) {
                String msg = cne + ": failed to retrieve node state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setMixinTypeNames(newMixins);
        this.setMixinTypesProperty(newMixins);
        HashSet<Name> set = new HashSet<Name>(thisState.getPropertyNames());
        for (Name propName : set) {
            PropertyState propState = null;
            try {
                propState = (PropertyState)this.stateMgr.getItemState(new PropertyId(thisState.getNodeId(), propName));
                this.itemMgr.getDefinition(propState);
            }
            catch (ConstraintViolationException cve) {
                try {
                    if (((ItemDefinition)oldDefs.get(propState.getId())).isProtected()) {
                        this.removeChildProperty(propName);
                        continue;
                    }
                    PropertyDefinitionImpl pdi = this.getApplicablePropertyDefinition(propName, propState.getType(), propState.isMultiValued(), false);
                    PropertyImpl prop = (PropertyImpl)this.itemMgr.getItem(propState.getId());
                    if (pdi.getRequiredType() != 0 && pdi.getRequiredType() != propState.getType()) {
                        if (propState.isMultiValued()) {
                            Value[] values = ValueHelper.convert(prop.getValues(), pdi.getRequiredType(), this.getSession().getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(values);
                        } else {
                            Value value = ValueHelper.convert(prop.getValue(), pdi.getRequiredType(), this.getSession().getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(value);
                        }
                    } else {
                        prop.onRedefine(pdi.unwrap());
                    }
                    addedDefs.remove(pdi.unwrap());
                }
                catch (ValueFormatException vfe) {
                    this.removeChildProperty(propName);
                }
                catch (ConstraintViolationException cve1) {
                    this.removeChildProperty(propName);
                }
            }
            catch (ItemStateException ise) {
                String msg = propName + ": failed to retrieve property state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(thisState.getChildNodeEntries());
        for (int i = list.size() - 1; i >= 0; --i) {
            ChildNodeEntry entry = list.get(i);
            NodeState nodeState = null;
            try {
                nodeState = (NodeState)this.stateMgr.getItemState(entry.getId());
                this.itemMgr.getDefinition(nodeState);
                continue;
            }
            catch (ConstraintViolationException cve) {
                try {
                    if (((ItemDefinition)oldDefs.get(nodeState.getId())).isProtected()) {
                        this.removeChildNode(entry.getId());
                        continue;
                    }
                    NodeDefinitionImpl ndi = this.getApplicableChildNodeDefinition(entry.getName(), nodeState.getNodeTypeName());
                    NodeImpl node = (NodeImpl)this.itemMgr.getItem(nodeState.getId());
                    node.onRedefine(ndi.unwrap());
                    addedDefs.remove(ndi.unwrap());
                }
                catch (ConstraintViolationException cve1) {
                    this.removeChildNode(entry.getId());
                }
                continue;
            }
            catch (ItemStateException ise) {
                String msg = entry + ": failed to retrieve node state";
                log.error(msg, ise);
                throw new RepositoryException(msg, ise);
            }
        }
        for (QItemDefinition def : addedDefs) {
            if (!def.isAutoCreated()) continue;
            if (def.definesNode()) {
                NodeDefinitionImpl ndi = ntMgr.getNodeDefinition((QNodeDefinition)def);
                this.createChildNode(def.getName(), (NodeTypeImpl)ndi.getDefaultPrimaryType(), null);
                continue;
            }
            PropertyDefinitionImpl pdi = ntMgr.getPropertyDefinition((QPropertyDefinition)def);
            this.createChildProperty(pdi.unwrap().getName(), pdi.getRequiredType(), pdi);
        }
    }

    @Override
    public String toString() {
        return "node " + super.toString();
    }

    private class SetPropertyOperation
    implements SessionWriteOperation<PropertyImpl> {
        private final Name name;
        private final Value value;
        private final boolean enforceType;

        public SetPropertyOperation(Name name, Value value, boolean enforceType) {
            this.name = name;
            this.value = value;
            this.enforceType = enforceType;
        }

        @Override
        public PropertyImpl perform(SessionContext context) throws RepositoryException {
            NodeImpl.this.itemSanityCheck();
            NodeImpl.this.checkSetProperty();
            int type = 0;
            if (this.value != null) {
                type = this.value.getType();
            }
            BitSet status = new BitSet();
            PropertyImpl property = NodeImpl.this.getOrCreateProperty(this.name, type, false, this.enforceType, status);
            try {
                property.setValue(this.value);
            }
            catch (RepositoryException e) {
                if (status.get(0)) {
                    NodeImpl.this.removeChildProperty(this.name);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (status.get(0)) {
                    NodeImpl.this.removeChildProperty(this.name);
                }
                throw e;
            }
            catch (Error e) {
                if (status.get(0)) {
                    NodeImpl.this.removeChildProperty(this.name);
                }
                throw e;
            }
            return property;
        }

        public String toString() {
            return "node.setProperty(" + this.name + ", " + this.value + ")";
        }
    }
}

