/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHierarchyManager
extends HierarchyManagerImpl
implements NodeStateListener {
    public static final int DEFAULT_UPPER_LIMIT = 10000;
    private static final int MAX_UPPER_LIMIT = Integer.getInteger("org.apache.jackrabbit.core.CachingHierarchyManager.cacheSize", 10000);
    private static final int CACHE_STATISTICS_LOG_INTERVAL_MILLIS = Integer.getInteger("org.apache.jackrabbit.core.CachingHierarchyManager.logInterval", 60000);
    private static Logger log = LoggerFactory.getLogger(CachingHierarchyManager.class);
    private final PathMap<LRUEntry> pathCache = new PathMap();
    private final ReferenceMap idCache = new ReferenceMap(0, 0);
    private final Object cacheMonitor = new Object();
    private final int upperLimit = MAX_UPPER_LIMIT;
    private final CacheStatistics idCacheStatistics = new CacheStatistics();
    private LRUEntry head;
    private LRUEntry tail;
    private boolean consistencyCheckEnabled;
    private static final int ITEM_STATE_EXCEPTION_LOG_INTERVAL_MILLIS = 60000;
    private long itemStateExceptionLogTimestamp = 0L;

    public CachingHierarchyManager(NodeId rootNodeId, ItemStateManager provider) {
        super(rootNodeId, provider);
        if (log.isTraceEnabled()) {
            log.trace("CachingHierarchyManager initialized. Max cache size = {}", (Object)this.upperLimit, (Object)new Exception());
        } else {
            log.debug("CachingHierarchyManager initialized. Max cache size = {}", (Object)this.upperLimit);
        }
    }

    public void enableConsistencyChecks(boolean enable) {
        this.consistencyCheckEnabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemId resolvePath(Path path, int typesAllowed) throws RepositoryException {
        PathMap.Element<LRUEntry> element;
        Path pathToNode = path;
        if ((typesAllowed & 1) == 0) {
            pathToNode = path.getAncestor(1);
        }
        if ((element = this.map(pathToNode)) == null) {
            return super.resolvePath(path, typesAllowed);
        }
        LRUEntry entry = element.get();
        if (element.hasPath(path)) {
            Object object = this.cacheMonitor;
            synchronized (object) {
                entry.touch();
            }
            return entry.getId();
        }
        Path.Element[] elements = path.getElements();
        try {
            return this.resolvePath(elements, element.getDepth() + 1, entry.getId(), typesAllowed);
        }
        catch (ItemStateException e) {
            String msg = "failed to retrieve state of intermediary node for entry: " + entry.getId() + ", path: " + path.getString();
            this.logItemStateException(msg, e);
            log.debug(msg);
            this.evictAll(entry.getId(), true);
            return super.resolvePath(path, typesAllowed);
        }
    }

    @Override
    protected void pathResolved(ItemId id, PathBuilder builder) throws MalformedPathException {
        if (id.denotesNode()) {
            this.cache((NodeId)id, builder.getPath());
        }
    }

    @Override
    protected void buildPath(PathBuilder builder, ItemState state, HierarchyManagerImpl.CycleDetector detector) throws ItemStateException, RepositoryException {
        PathMap.Element<LRUEntry> element;
        if (state.isNode() && (element = this.get(state.getId())) != null) {
            try {
                Path.Element[] elements = element.getPath().getElements();
                for (int i = elements.length - 1; i >= 0; --i) {
                    builder.addFirst(elements[i]);
                }
                return;
            }
            catch (MalformedPathException mpe) {
                String msg = "Failed to build path of " + state.getId();
                log.debug(msg);
                throw new RepositoryException(msg, mpe);
            }
        }
        super.buildPath(builder, state, detector);
        if (state.isNode()) {
            try {
                this.cache(((NodeState)state).getNodeId(), builder.getPath());
            }
            catch (MalformedPathException mpe) {
                log.warn("Failed to build path of " + state.getId());
            }
        }
    }

    @Override
    public Path getPath(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element<LRUEntry> element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            try {
                return element.getPath();
            }
            catch (MalformedPathException mpe) {
                String msg = "Failed to build path of " + id;
                log.debug(msg);
                throw new RepositoryException(msg, mpe);
            }
        }
        return super.getPath(id);
    }

    @Override
    public Name getName(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element<LRUEntry> element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            return element.getName();
        }
        return super.getName(id);
    }

    @Override
    public int getDepth(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element<LRUEntry> element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            return element.getDepth();
        }
        return super.getDepth(id);
    }

    @Override
    public boolean isAncestor(NodeId nodeId, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        PathMap.Element<LRUEntry> child;
        PathMap.Element<LRUEntry> element;
        if (itemId.denotesNode() && (element = this.get(nodeId)) != null && (child = this.get(itemId)) != null) {
            return element.isAncestorOf(child);
        }
        return super.isAncestor(nodeId, itemId);
    }

    @Override
    public void stateCreated(ItemState created) {
    }

    @Override
    public void stateModified(ItemState modified) {
        if (modified.isNode()) {
            this.nodeModified((NodeState)modified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeModified(NodeState modified) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            for (PathMap.Element<LRUEntry> element : this.getCachedPaths(modified.getNodeId())) {
                for (PathMap.Element<LRUEntry> child : element.getChildren()) {
                    ChildNodeEntry cne = modified.getChildNodeEntry(child.getName(), child.getNormalizedIndex());
                    if (cne == null) {
                        this.evict(child, true);
                        continue;
                    }
                    LRUEntry childEntry = child.get();
                    if (childEntry == null || cne.getId().equals(childEntry.getId())) continue;
                    this.evict(child, true);
                }
            }
            this.checkConsistency();
        }
    }

    private List<PathMap.Element<LRUEntry>> getCachedPaths(NodeId id) {
        if (this.rootNodeId.equals(id)) {
            return Collections.singletonList(this.pathCache.map(PathFactoryImpl.getInstance().getRootPath(), true));
        }
        LRUEntry entry = (LRUEntry)this.idCache.get(id);
        if (entry != null) {
            return Arrays.asList(entry.getElements());
        }
        return Collections.emptyList();
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        this.evictAll(destroyed.getId(), true);
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        if (discarded.isTransient() && !discarded.hasOverlayedState() && discarded.getStatus() == 4) {
            this.evictAll(discarded.getId(), true);
        } else if (this.provider.hasItemState(discarded.getId())) {
            this.evictAll(discarded.getId(), false);
        } else {
            this.evictAll(discarded.getId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (this.idCache.containsKey(state.getNodeId())) {
                try {
                    Path path = PathFactoryImpl.getInstance().create(this.getPath(state.getNodeId()), name, index, true);
                    this.nodeAdded(state, path, id);
                    this.checkConsistency();
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to get path of node " + state.getNodeId() + ", event ignored.");
                }
                catch (MalformedPathException e) {
                    log.warn("Unable to create path of " + id, e);
                }
                catch (ItemNotFoundException e) {
                    log.warn("Unable to find item " + state.getNodeId(), e);
                }
                catch (ItemStateException e) {
                    log.warn("Unable to find item " + id, e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), e);
                }
            } else if (state.getParentId() == null && this.idCache.containsKey(id)) {
                this.evictAll(id, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesReplaced(NodeState state) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get(state.getNodeId());
            if (entry == null) {
                return;
            }
            for (PathMap.Element<LRUEntry> parent : entry.getElements()) {
                HashMap newChildrenOrder = new HashMap();
                boolean orderChanged = false;
                for (PathMap.Element<LRUEntry> child : parent.getChildren()) {
                    LRUEntry childEntry = child.get();
                    if (childEntry == null) {
                        this.evict(child, false);
                        continue;
                    }
                    NodeId childId = childEntry.getId();
                    ChildNodeEntry cne = state.getChildNodeEntry(childId);
                    if (cne == null) {
                        this.evict(child, false);
                        continue;
                    }
                    Path.Element newNameIndex = PathFactoryImpl.getInstance().createElement(cne.getName(), cne.getIndex());
                    newChildrenOrder.put(newNameIndex, child);
                    if (newNameIndex.equals(child.getPathElement())) continue;
                    orderChanged = true;
                }
                if (!orderChanged) continue;
                parent.setChildren(newChildrenOrder);
            }
            this.checkConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (this.idCache.containsKey(state.getNodeId())) {
                try {
                    Path path = PathFactoryImpl.getInstance().create(this.getPath(state.getNodeId()), name, index, true);
                    this.nodeRemoved(state, path, id);
                    this.checkConsistency();
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to get path of node " + state.getNodeId() + ", event ignored.");
                }
                catch (MalformedPathException e) {
                    log.warn("Unable to create path of " + id, e);
                }
                catch (ItemStateException e) {
                    log.warn("Unable to find item " + id, e);
                }
                catch (ItemNotFoundException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), e);
                }
            } else if (state.getParentId() == null && this.idCache.containsKey(id)) {
                this.evictAll(id, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathMap.Element<LRUEntry> get(ItemId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get(id);
            if (entry != null) {
                entry.touch();
                return entry.getElements()[0];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathMap.Element<LRUEntry> map(Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            for (PathMap.Element<LRUEntry> element = this.pathCache.map(path, false); element != null; element = element.getParent()) {
                LRUEntry entry = element.get();
                if (entry == null) continue;
                entry.touch();
                return element;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(NodeId id, Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry;
            PathMap.Element<LRUEntry> element;
            if (this.isCached(id, path)) {
                return;
            }
            if (this.idCache.size() >= this.upperLimit) {
                this.idCacheStatistics.log();
                for (LRUEntry entry2 = this.head; entry2 != null; entry2 = entry2.getNext()) {
                    PathMap.Element<LRUEntry>[] elements = entry2.getElements();
                    int childrenCount = 0;
                    for (int i = 0; i < elements.length; ++i) {
                        childrenCount += elements[i].getChildrenCount();
                    }
                    if (childrenCount != 0) continue;
                    this.evictAll(entry2.getId(), false);
                    return;
                }
            }
            if ((element = this.pathCache.put(path)).get() != null && !id.equals(element.get().getId())) {
                log.debug("overwriting PathMap.Element");
            }
            if ((entry = (LRUEntry)this.idCache.get(id)) == null) {
                entry = new LRUEntry(id, element);
                this.idCache.put(id, entry);
            } else {
                entry.addElement(element);
            }
            element.set(entry);
            this.checkConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCached(NodeId id, Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get(id);
            if (entry == null) {
                return false;
            }
            if (path == null) {
                return true;
            }
            PathMap.Element<LRUEntry>[] elements = entry.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].hasPath(path)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCached(Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            PathMap.Element<LRUEntry> element = this.pathCache.map(path, true);
            if (element != null) {
                return element.get() != null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictAll(ItemId id, boolean shift) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get(id);
            if (entry != null) {
                PathMap.Element<LRUEntry>[] elements = entry.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    this.evict(elements[i], shift);
                }
            }
            this.checkConsistency();
        }
    }

    private void evict(PathMap.Element<LRUEntry> element, boolean shift) {
        element.traverse(new PathMap.ElementVisitor<LRUEntry>(){

            @Override
            public void elementVisited(PathMap.Element<LRUEntry> element) {
                LRUEntry entry = element.get();
                if (entry.removeElement(element) == 0) {
                    CachingHierarchyManager.this.idCache.remove(entry.getId());
                    entry.remove();
                }
            }
        }, false);
        element.remove(shift);
    }

    private void nodeAdded(NodeState state, Path path, NodeId id) throws RepositoryException, ItemStateException {
        PathMap.Element<LRUEntry> parent;
        PathMap.Element<LRUEntry> element = null;
        LRUEntry entry = (LRUEntry)this.idCache.get(id);
        if (entry != null) {
            NodeState child = null;
            if (this.hasItemState(id)) {
                child = (NodeState)this.getItemState(id);
            }
            if (child == null || !child.isShareable()) {
                PathMap.Element<LRUEntry>[] elements = entry.getElements();
                element = elements[0];
                for (int i = 0; i < elements.length; ++i) {
                    elements[i].remove();
                }
            }
        }
        if ((parent = this.pathCache.map(path.getAncestor(1), true)) != null) {
            parent.insert(path.getNameElement());
        }
        if (element != null) {
            this.pathCache.put(path, element);
        }
    }

    private void nodeRemoved(NodeState state, Path path, NodeId id) throws RepositoryException, ItemStateException {
        PathMap.Element<LRUEntry> parent = this.pathCache.map(path.getAncestor(1), true);
        if (parent == null) {
            return;
        }
        PathMap.Element<LRUEntry> element = parent.getDescendant(path.getLastElement(), true);
        if (element != null) {
            LRUEntry entry = element.get();
            if (entry != null && !entry.getId().equals(id)) {
                return;
            }
            NodeState child = null;
            if (this.hasItemState(id)) {
                child = (NodeState)this.getItemState(id);
            }
            if (child == null || !child.isShareable()) {
                this.evictAll(id, true);
            } else {
                this.evict(element, true);
            }
        } else {
            parent.remove(path.getNameElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        final StringBuilder builder = new StringBuilder();
        Object object = this.cacheMonitor;
        synchronized (object) {
            this.pathCache.traverse(new PathMap.ElementVisitor<LRUEntry>(){

                @Override
                public void elementVisited(PathMap.Element<LRUEntry> element) {
                    for (int i = 0; i < element.getDepth(); ++i) {
                        builder.append("--");
                    }
                    builder.append(element.getName());
                    int index = element.getIndex();
                    if (index != 0 && index != 1) {
                        builder.append('[');
                        builder.append(index);
                        builder.append(']');
                    }
                    builder.append("  ");
                    builder.append(element.get());
                    builder.append("\n");
                }
            }, true);
        }
        return builder.toString();
    }

    private void checkConsistency() throws IllegalStateException {
        if (!this.consistencyCheckEnabled) {
            return;
        }
        int elementsInCache = 0;
        for (LRUEntry entry : this.idCache.values()) {
            elementsInCache += entry.getElements().length;
        }
        class PathMapElementCounter
        implements PathMap.ElementVisitor<LRUEntry> {
            int count;

            PathMapElementCounter() {
            }

            @Override
            public void elementVisited(PathMap.Element<LRUEntry> element) {
                LRUEntry mappedEntry = element.get();
                LRUEntry cachedEntry = (LRUEntry)CachingHierarchyManager.this.idCache.get(mappedEntry.getId());
                if (cachedEntry == null) {
                    String msg = "Path element (" + element + " ) cached in path map, associated id (" + mappedEntry.getId() + ") isn't.";
                    throw new IllegalStateException(msg);
                }
                if (cachedEntry != mappedEntry) {
                    String msg = "LRUEntry associated with element (" + element + " ) in path map is not equal to cached LRUEntry (" + cachedEntry.getId() + ").";
                    throw new IllegalStateException(msg);
                }
                PathMap.Element<LRUEntry>[] elements = cachedEntry.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i] != element) continue;
                    ++this.count;
                    return;
                }
                String msg = "Element (" + element + ") cached in path map, but not in associated LRUEntry (" + cachedEntry.getId() + ").";
                throw new IllegalStateException(msg);
            }
        }
        PathMapElementCounter counter = new PathMapElementCounter();
        this.pathCache.traverse(counter, false);
        if (counter.count != elementsInCache) {
            String msg = "PathMap element and cached element count don't match (" + counter.count + " != " + elementsInCache + ")";
            throw new IllegalStateException(msg);
        }
    }

    private void logItemStateException(String logMessage, ItemStateException e) {
        long now = System.currentTimeMillis();
        if (now - this.itemStateExceptionLogTimestamp >= 60000L) {
            this.itemStateExceptionLogTimestamp = now;
            log.debug(logMessage, e);
        } else {
            log.debug(logMessage);
        }
    }

    private final class CacheStatistics {
        private final String id;
        private final ReferenceMap cache;
        private long timeStamp = 0L;

        public CacheStatistics() {
            this.id = CachingHierarchyManager.this.cacheMonitor.toString();
            this.cache = CachingHierarchyManager.this.idCache;
        }

        public void log() {
            if (log.isDebugEnabled()) {
                long now = System.currentTimeMillis();
                String msg = "Cache id = {};size = {};max = {}";
                if (log.isTraceEnabled()) {
                    log.trace("Cache id = {};size = {};max = {}", (Object)new Object[]{this.id, this.cache.size(), CachingHierarchyManager.this.upperLimit}, (Object)new Exception());
                } else if (now > this.timeStamp + (long)CACHE_STATISTICS_LOG_INTERVAL_MILLIS) {
                    this.timeStamp = now;
                    log.debug("Cache id = {};size = {};max = {}", (Object)new Object[]{this.id, this.cache.size(), CachingHierarchyManager.this.upperLimit}, (Object)new Exception());
                }
            }
        }
    }

    private class LRUEntry {
        private LRUEntry previous;
        private LRUEntry next;
        private final NodeId id;
        private PathMap.Element<LRUEntry>[] elements;

        public LRUEntry(NodeId id, PathMap.Element<LRUEntry> element) {
            this.id = id;
            this.elements = new PathMap.Element[]{element};
            this.append();
        }

        public void append() {
            if (CachingHierarchyManager.this.tail == null) {
                CachingHierarchyManager.this.head = this;
                CachingHierarchyManager.this.tail = this;
            } else {
                this.previous = CachingHierarchyManager.this.tail;
                ((CachingHierarchyManager)CachingHierarchyManager.this).tail.next = this;
                CachingHierarchyManager.this.tail = this;
            }
        }

        public void remove() {
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (CachingHierarchyManager.this.head == this) {
                CachingHierarchyManager.this.head = this.next;
            }
            if (CachingHierarchyManager.this.tail == this) {
                CachingHierarchyManager.this.tail = this.previous;
            }
            this.previous = null;
            this.next = null;
        }

        public void touch() {
            this.remove();
            this.append();
        }

        public LRUEntry getNext() {
            return this.next;
        }

        public NodeId getId() {
            return this.id;
        }

        public PathMap.Element<LRUEntry>[] getElements() {
            return this.elements;
        }

        public void addElement(PathMap.Element<LRUEntry> element) {
            PathMap.Element[] tmp = new PathMap.Element[this.elements.length + 1];
            System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
            tmp[this.elements.length] = element;
            this.elements = tmp;
        }

        public int removeElement(PathMap.Element<LRUEntry> element) {
            boolean found = false;
            for (int i = 0; i < this.elements.length; ++i) {
                if (found) {
                    this.elements[i - 1] = this.elements[i];
                    continue;
                }
                if (this.elements[i] != element) continue;
                found = true;
            }
            if (found) {
                PathMap.Element[] tmp = new PathMap.Element[this.elements.length - 1];
                System.arraycopy(this.elements, 0, tmp, 0, tmp.length);
                this.elements = tmp;
            }
            return this.elements.length;
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

