/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.tool.common.ImportTsFileOperation;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;

public abstract class ImportTsFileBase
implements Runnable {
    private static final IoTPrinter IOT_PRINTER = new IoTPrinter(System.out);
    private static final LongAdder loadFileSuccessfulNum = new LongAdder();
    private static final LongAdder loadFileFailedNum = new LongAdder();
    private static final LongAdder processingLoadSuccessfulFileSuccessfulNum = new LongAdder();
    private static final LongAdder processingLoadFailedFileSuccessfulNum = new LongAdder();
    private static String timePrecision = "ms";
    private static String successDir;
    private static ImportTsFileOperation successOperation;
    private static String failDir;
    private static ImportTsFileOperation failOperation;

    @Override
    public void run() {
        this.loadTsFile();
    }

    protected abstract void loadTsFile();

    protected void processFailFile(String filePath, Exception e) {
        try {
            if (Objects.nonNull(e.getMessage()) && e.getMessage().contains("memory")) {
                IOT_PRINTER.println("Rejecting file [ " + filePath + " ] due to memory constraints, will retry later.");
                ImportTsFileScanTool.putToQueue(filePath);
                return;
            }
            loadFileFailedNum.increment();
            IOT_PRINTER.println("Failed to import [ " + filePath + " ] file: " + e.getMessage());
            try {
                ImportTsFileBase.processingFile(filePath, false);
                processingLoadFailedFileSuccessfulNum.increment();
                IOT_PRINTER.println("Processed fail file [ " + filePath + " ] successfully!");
            }
            catch (Exception processFailException) {
                IOT_PRINTER.println("Failed to process fail file [ " + filePath + " ]: " + processFailException.getMessage());
            }
        }
        catch (InterruptedException e1) {
            IOT_PRINTER.println("Unexpected error occurred: " + e1.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (Exception e1) {
            IOT_PRINTER.println("Unexpected error occurred: " + e1.getMessage());
        }
    }

    protected static void processSuccessFile(String filePath) {
        loadFileSuccessfulNum.increment();
        IOT_PRINTER.println("Imported [ " + filePath + " ] file successfully!");
        try {
            ImportTsFileBase.processingFile(filePath, true);
            processingLoadSuccessfulFileSuccessfulNum.increment();
            IOT_PRINTER.println("Processed success file [ " + filePath + " ] successfully!");
        }
        catch (Exception processSuccessException) {
            IOT_PRINTER.println("Failed to process success file [ " + filePath + " ]: " + processSuccessException.getMessage());
        }
    }

    public static void processingFile(String filePath, boolean isSuccess) {
        String relativePath = filePath.substring(ImportTsFileScanTool.getSourceFullPathLength() + 1);
        Path sourcePath = Paths.get(filePath, new String[0]);
        String target = isSuccess ? successDir : failDir + File.separator + relativePath.replace(File.separator, "_");
        Path targetPath = Paths.get(target, new String[0]);
        String RESOURCE = ".resource";
        Path sourceResourcePath = Paths.get(sourcePath + ".resource", new String[0]);
        sourceResourcePath = Files.exists(sourceResourcePath, new LinkOption[0]) ? sourceResourcePath : null;
        Path targetResourcePath = Paths.get(target + ".resource", new String[0]);
        String MODS = ".mods";
        Path sourceModsPath = Paths.get(sourcePath + ".mods", new String[0]);
        sourceModsPath = Files.exists(sourceModsPath, new LinkOption[0]) ? sourceModsPath : null;
        Path targetModsPath = Paths.get(target + ".mods", new String[0]);
        switch (isSuccess ? successOperation : failOperation) {
            case DELETE: {
                try {
                    Files.deleteIfExists(sourcePath);
                    if (null != sourceResourcePath) {
                        Files.deleteIfExists(sourceResourcePath);
                    }
                    if (null == sourceModsPath) break;
                    Files.deleteIfExists(sourceModsPath);
                }
                catch (Exception e) {
                    IOT_PRINTER.println(String.format("Failed to delete file: %s", e.getMessage()));
                }
                break;
            }
            case CP: {
                try {
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (null != sourceResourcePath) {
                        Files.copy(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.copy(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    IOT_PRINTER.println(String.format("Failed to copy file: %s", e.getMessage()));
                }
                break;
            }
            case HARDLINK: {
                try {
                    Files.createLink(targetPath, sourcePath);
                }
                catch (FileAlreadyExistsException e) {
                    IOT_PRINTER.println("Hardlink already exists: " + e.getMessage());
                }
                catch (Exception e) {
                    try {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception copyException) {
                        IOT_PRINTER.println(String.format("Failed to copy file: %s", copyException.getMessage()));
                    }
                }
                try {
                    if (null != sourceResourcePath) {
                        Files.copy(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.copy(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    IOT_PRINTER.println(String.format("Failed to copy resource or mods file: %s", e.getMessage()));
                }
                break;
            }
            case MV: {
                try {
                    Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (null != sourceResourcePath) {
                        Files.move(sourceResourcePath, targetResourcePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (null == sourceModsPath) break;
                    Files.move(sourceModsPath, targetModsPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    IOT_PRINTER.println(String.format("Failed to move file: %s", e.getMessage()));
                }
                break;
            }
        }
    }

    protected static void printResult(long startTime) {
        IOT_PRINTER.println("Successfully load " + loadFileSuccessfulNum.sum() + " tsfile(s) (--on_success operation(s): " + processingLoadSuccessfulFileSuccessfulNum.sum() + " succeed, " + (loadFileSuccessfulNum.sum() - processingLoadSuccessfulFileSuccessfulNum.sum()) + " failed)");
        IOT_PRINTER.println("Failed to load " + loadFileFailedNum.sum() + " file(s) (--on_fail operation(s): " + processingLoadFailedFileSuccessfulNum.sum() + " succeed, " + (loadFileFailedNum.sum() - processingLoadFailedFileSuccessfulNum.sum()) + " failed)");
        IOT_PRINTER.println("Unprocessed " + ImportTsFileScanTool.getTsFileQueueSize() + " file(s), due to unexpected exceptions");
        IOT_PRINTER.println("For more details, please check the log.");
        IOT_PRINTER.println("Total operation time: " + (System.currentTimeMillis() - startTime) + " ms.");
        IOT_PRINTER.println("Work has been completed!");
    }

    public static void setSuccessAndFailDirAndOperation(String successDir, ImportTsFileOperation successOperation, String failDir, ImportTsFileOperation failOperation) {
        ImportTsFileBase.successDir = successDir;
        ImportTsFileBase.successOperation = successOperation;
        ImportTsFileBase.failDir = failDir;
        ImportTsFileBase.failOperation = failOperation;
    }

    protected void setTimePrecision(String timePrecision) {
        ImportTsFileBase.timePrecision = timePrecision;
    }

    protected String getTimePrecision() {
        return timePrecision;
    }
}

