/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.WindowNode;

public class PruneWindowColumns
extends ProjectOffPushDownRule<WindowNode> {
    public PruneWindowColumns() {
        super(Patterns.window());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, WindowNode windowNode, Set<Symbol> referencedOutputs) {
        Map referencedFunctions = Maps.filterKeys(windowNode.getWindowFunctions(), referencedOutputs::contains);
        if (referencedFunctions.isEmpty()) {
            return Optional.of(windowNode.getChild());
        }
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder().addAll(windowNode.getChild().getOutputSymbols().stream().filter(referencedOutputs::contains).iterator()).addAll(windowNode.getSpecification().getPartitionBy());
        windowNode.getSpecification().getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderBy().forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0)));
        windowNode.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        for (WindowNode.Function windowFunction : referencedFunctions.values()) {
            referencedInputs.addAll(SymbolsExtractor.extractUnique(windowFunction));
        }
        WindowNode prunedWindowNode = new WindowNode(windowNode.getPlanNodeId(), Util.restrictOutputs(context.getIdAllocator(), windowNode.getChild(), (Set<Symbol>)referencedInputs.build()).orElse(windowNode.getChild()), windowNode.getSpecification(), referencedFunctions, windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix());
        if (((PlanNode)prunedWindowNode).getOutputSymbols().size() == windowNode.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of(prunedWindowNode);
    }
}

