/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class EnumField
extends EnumValueType
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=102");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14845");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14801");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15083");
    private final String name;

    public EnumField(Long value, LocalizedText displayName, LocalizedText description, String name) {
        super(value, displayName, description);
        this.name = name;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public String getName() {
        return this.name;
    }

    protected EnumField(EnumFieldBuilder<?, ?> b) {
        super((EnumValueType.EnumValueTypeBuilder<?, ?>)b);
        this.name = ((EnumFieldBuilder)b).name;
    }

    public static EnumFieldBuilder<?, ?> builder() {
        return new EnumFieldBuilderImpl();
    }

    public EnumFieldBuilder<?, ?> toBuilder() {
        return new EnumFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumField)) {
            return false;
        }
        EnumField other = (EnumField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumField;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EnumField(name=" + this.getName() + ")";
    }

    private static final class EnumFieldBuilderImpl
    extends EnumFieldBuilder<EnumField, EnumFieldBuilderImpl> {
        private EnumFieldBuilderImpl() {
        }

        @Override
        protected EnumFieldBuilderImpl self() {
            return this;
        }

        @Override
        public EnumField build() {
            return new EnumField(this);
        }
    }

    public static abstract class EnumFieldBuilder<C extends EnumField, B extends EnumFieldBuilder<C, B>>
    extends EnumValueType.EnumValueTypeBuilder<C, B> {
        private String name;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EnumFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EnumField instance, EnumFieldBuilder<?, ?> b) {
            b.name(instance.name);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EnumField.EnumFieldBuilder(super=" + super.toString() + ", name=" + this.name + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EnumField> {
        @Override
        public Class<EnumField> getType() {
            return EnumField.class;
        }

        @Override
        public EnumField decode(SerializationContext context, UaDecoder decoder) {
            Long value = decoder.readInt64("Value");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            String name = decoder.readString("Name");
            return new EnumField(value, displayName, description, name);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EnumField value) {
            encoder.writeInt64("Value", value.getValue());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeString("Name", value.getName());
        }
    }
}

