/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.PauseArchivingPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class ResumeArchivingOperator
extends Operator {
    private long taskId = -1L;
    private PartialPath storageGroup;

    public ResumeArchivingOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.PAUSE_ARCHIVING;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setStorageGroup(PartialPath storageGroup) {
        this.storageGroup = storageGroup;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        if (this.storageGroup != null) {
            return new PauseArchivingPlan(this.storageGroup, false);
        }
        if (this.taskId != -1L) {
            return new PauseArchivingPlan(this.taskId, false);
        }
        return new PauseArchivingPlan(false);
    }
}

