/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.heartbeat.HeartbeatThread;
import org.apache.iotdb.cluster.server.member.DataGroupMember;

public class DataHeartbeatThread
extends HeartbeatThread {
    private static final int MAX_ELECTIONS_TO_SKIP = 5;
    private DataGroupMember dataGroupMember;
    private int skippedElectionNumber = 0;

    public DataHeartbeatThread(DataGroupMember raftMember) {
        super(raftMember);
        this.dataGroupMember = raftMember;
    }

    @Override
    void sendHeartbeatSync(Node node) {
        this.request.setHeader(this.dataGroupMember.getHeader());
        super.sendHeartbeatSync(node);
    }

    @Override
    void sendHeartbeatAsync(Node node) {
        this.request.setHeader(this.dataGroupMember.getHeader());
        super.sendHeartbeatAsync(node);
    }

    @Override
    void startElection() {
        if (!this.dataGroupMember.getThisNode().equals(this.dataGroupMember.getHeader().getNode()) && this.skippedElectionNumber < 5 && !this.hasHadLeader) {
            ++this.skippedElectionNumber;
            return;
        }
        this.electionRequest.setHeader(this.dataGroupMember.getHeader());
        super.startElection();
    }
}

