/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.policy.PolicyType;

public class PolicyEntity
extends PolarisEntity {
    public static final String POLICY_TYPE_CODE_KEY = "policy-type-code";
    public static final String POLICY_DESCRIPTION_KEY = "policy-description";
    public static final String POLICY_VERSION_KEY = "policy-version";
    public static final String POLICY_CONTENT_KEY = "policy-content";

    PolicyEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static PolicyEntity of(PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new PolicyEntity(sourceEntity);
        }
        return null;
    }

    @JsonIgnore
    public PolicyType getPolicyType() {
        return PolicyType.fromCode(this.getPolicyTypeCode());
    }

    @JsonIgnore
    public int getPolicyTypeCode() {
        Preconditions.checkArgument((boolean)this.getPropertiesAsMap().containsKey(POLICY_TYPE_CODE_KEY), (Object)"Invalid policy entity: policy type must exist");
        String policyTypeCode = this.getPropertiesAsMap().get(POLICY_TYPE_CODE_KEY);
        return Integer.parseInt(policyTypeCode);
    }

    @JsonIgnore
    public String getDescription() {
        return this.getPropertiesAsMap().get(POLICY_DESCRIPTION_KEY);
    }

    @JsonIgnore
    public String getContent() {
        return this.getPropertiesAsMap().get(POLICY_CONTENT_KEY);
    }

    @JsonIgnore
    public int getPolicyVersion() {
        return Integer.parseInt(this.getPropertiesAsMap().get(POLICY_VERSION_KEY));
    }

    @JsonIgnore
    public Namespace getParentNamespace() {
        String parentNamespace = this.getInternalPropertiesAsMap().get("parent-namespace");
        if (parentNamespace != null) {
            return RESTUtil.decodeNamespace((String)parentNamespace);
        }
        return null;
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<PolicyEntity, Builder> {
        public Builder(Namespace namespace, String policyName, PolicyType policyType) {
            this.setType(PolarisEntityType.POLICY);
            this.setParentNamespace(namespace);
            this.setName(policyName);
            this.setPolicyType(policyType);
            this.setPolicyVersion(0);
        }

        public Builder(PolicyEntity original) {
            super(original);
        }

        @Override
        public PolicyEntity build() {
            Preconditions.checkArgument((boolean)this.properties.containsKey(PolicyEntity.POLICY_TYPE_CODE_KEY), (Object)"Policy type must be specified");
            return new PolicyEntity(this.buildBase());
        }

        public Builder setParentNamespace(Namespace namespace) {
            if (namespace != null && !namespace.isEmpty()) {
                this.internalProperties.put("parent-namespace", RESTUtil.encodeNamespace((Namespace)namespace));
            }
            return this;
        }

        public Builder setPolicyType(PolicyType policyType) {
            Preconditions.checkArgument((policyType != null ? 1 : 0) != 0, (Object)"Policy type must be specified");
            this.properties.put(PolicyEntity.POLICY_TYPE_CODE_KEY, Integer.toString(policyType.getCode()));
            return this;
        }

        public Builder setDescription(String description) {
            this.properties.put(PolicyEntity.POLICY_DESCRIPTION_KEY, description);
            return this;
        }

        public Builder setPolicyVersion(int version) {
            this.properties.put(PolicyEntity.POLICY_VERSION_KEY, Integer.toString(version));
            return this;
        }

        public Builder setContent(String content) {
            this.properties.put(PolicyEntity.POLICY_CONTENT_KEY, content);
            return this;
        }
    }
}

