/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.api.proxy;

import com.arjuna.ats.arjuna.tools.osb.api.mbeans.ParticipantStoreBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.api.mbeans.RecoveryStoreBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.api.proxy.ParticipantStoreProxy;
import com.arjuna.ats.arjuna.tools.osb.api.proxy.RecoveryStoreProxy;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class StoreManagerProxy {
    public static final String RECOVERY_BEAN_NAME = "jboss.jta:type=com.arjuna.ats.arjuna.tools.osb.api.mbeans.RecoveryStoreBean,name=store1";
    public static final String PARTICIPANT_BEAN_NAME = "jboss.jta:type=com.arjuna.ats.arjuna.tools.osb.api.mbeans.ParticipantStoreBean,name=store1";
    private static Map<String, StoreManagerProxy> proxies = Collections.synchronizedMap(new HashMap());
    private static JMXConnectorServer jmxCServer;
    private MBeanServerConnection mbsc;
    private JMXConnector jmxc;
    private RecoveryStoreProxy rsProxy;
    private ParticipantStoreProxy psProxy;
    private ObjectName recoveryStoreON;
    private ObjectName participantStoreON;
    private NotificationListener recoveryListener = null;
    private NotificationListener participantListener = null;

    private StoreManagerProxy(String serviceUrl, NotificationListener listener) throws JMException, IOException {
        if ("default".equals(serviceUrl)) {
            this.mbsc = JMXServer.getAgent().getServer();
        } else {
            JMXServiceURL url = new JMXServiceURL(serviceUrl);
            this.jmxc = JMXConnectorFactory.connect(url, null);
            this.mbsc = this.jmxc.getMBeanServerConnection();
        }
        this.recoveryStoreON = ObjectName.getInstance(RECOVERY_BEAN_NAME);
        this.participantStoreON = ObjectName.getInstance(PARTICIPANT_BEAN_NAME);
        this.rsProxy = new RecoveryStoreProxy(JMX.newMBeanProxy(this.mbsc, this.recoveryStoreON, RecoveryStoreBeanMBean.class, true));
        this.psProxy = new ParticipantStoreProxy(JMX.newMBeanProxy(this.mbsc, this.participantStoreON, ParticipantStoreBeanMBean.class, true));
        if (listener != null) {
            this.mbsc.addNotificationListener(this.recoveryStoreON, listener, null, null);
            this.mbsc.addNotificationListener(this.participantStoreON, listener, null, null);
        }
    }

    private void close() throws JMException, IOException {
        System.out.println("Remove notification listener...");
        if (this.recoveryListener != null) {
            this.mbsc.removeNotificationListener(this.recoveryStoreON, this.recoveryListener);
        }
        if (this.participantListener != null) {
            this.mbsc.removeNotificationListener(this.participantStoreON, this.participantListener);
        }
        this.participantListener = null;
        this.recoveryListener = null;
        if (this.jmxc != null) {
            this.jmxc.close();
            this.jmxc = null;
        }
    }

    public static void startServerConnector(String serviceUrl) throws IOException {
        jmxCServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceUrl), null, JMXServer.getAgent().getServer());
        jmxCServer.start();
    }

    public static void stopServerConnector() throws IOException {
        jmxCServer.stop();
    }

    public static boolean registerBean(ObjectName name, Object bean, boolean register) {
        try {
            MBeanServer mbs = JMXServer.getAgent().getServer();
            boolean isRegistered = mbs.isRegistered(name);
            System.out.println((register ? "" : "un") + "registering bean " + String.valueOf(name));
            if (register && isRegistered) {
                System.out.println(String.valueOf(name) + " is already registered");
                return true;
            }
            if (!register && !isRegistered) {
                System.out.println(String.valueOf(name) + " is not registered");
                return true;
            }
            if (register) {
                mbs.registerMBean(bean, name);
            } else {
                mbs.unregisterMBean(name);
            }
            return true;
        }
        catch (JMException e) {
            System.out.println("MBean registration error: " + e.getMessage());
            return false;
        }
    }

    private static synchronized StoreManagerProxy getProxy(String serviceUrl, NotificationListener listener) throws IOException, JMException {
        if (serviceUrl == null) {
            serviceUrl = "default";
        }
        if (!proxies.containsKey(serviceUrl)) {
            proxies.put(serviceUrl, new StoreManagerProxy(serviceUrl, listener));
        }
        return proxies.get(serviceUrl);
    }

    public static void releaseProxy() throws JMException, IOException {
        StoreManagerProxy.releaseProxy("default");
    }

    public static void releaseProxy(String serviceUrl) throws JMException, IOException {
        StoreManagerProxy psm = proxies.remove(serviceUrl);
        if (psm != null) {
            psm.close();
        }
    }

    public static synchronized RecoveryStoreProxy getRecoveryStore() throws IOException, JMException {
        return StoreManagerProxy.getRecoveryStore(null);
    }

    public static synchronized RecoveryStoreProxy getRecoveryStore(NotificationListener listener) throws IOException, JMException {
        return StoreManagerProxy.getProxy((String)"default", (NotificationListener)listener).rsProxy;
    }

    public static synchronized RecoveryStoreProxy getRecoveryStore(String serviceUrl, NotificationListener listener) throws IOException, JMException {
        return StoreManagerProxy.getProxy((String)serviceUrl, (NotificationListener)listener).rsProxy;
    }

    public static synchronized ParticipantStoreProxy getParticipantStore() throws IOException, JMException {
        return StoreManagerProxy.getParticipantStore(null);
    }

    public static synchronized ParticipantStoreProxy getParticipantStore(NotificationListener listener) throws IOException, JMException {
        return StoreManagerProxy.getProxy((String)"default", (NotificationListener)listener).psProxy;
    }

    public static synchronized ParticipantStoreProxy getParticipantStore(String serviceUrl, NotificationListener listener) throws IOException, JMException {
        return StoreManagerProxy.getProxy((String)serviceUrl, (NotificationListener)listener).psProxy;
    }
}

