/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.net.URI;
import org.apache.polaris.core.storage.azure.AzureLocation;

public class StorageLocation {
    private final String location;
    public static final String LOCAL_PATH_PREFIX = "file:///";

    public static StorageLocation of(String location) {
        if (AzureLocation.isAzureLocation(location)) {
            return new AzureLocation(location);
        }
        return new StorageLocation(location);
    }

    protected StorageLocation(@Nonnull String location) {
        this.location = location == null ? null : (location.startsWith("file:/") ? URI.create(location.replaceFirst("file:/+", LOCAL_PATH_PREFIX)).toString() : (location.startsWith("/") ? URI.create(location.replaceFirst("/+", LOCAL_PATH_PREFIX)).toString() : location));
    }

    protected final String ensureTrailingSlash(String location) {
        if (location == null || location.endsWith("/")) {
            return location;
        }
        return location + "/";
    }

    @Nonnull
    protected final String ensureLeadingSlash(@Nonnull String location) {
        if (location.startsWith("/")) {
            return location;
        }
        return "/" + location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageLocation) {
            return this.location.equals(((StorageLocation)obj).location);
        }
        return false;
    }

    public String toString() {
        return this.location;
    }

    public boolean isChildOf(StorageLocation potentialParent) {
        if (this.location == null || potentialParent.location == null) {
            return false;
        }
        String slashTerminatedLocation = this.ensureTrailingSlash(this.location);
        String slashTerminatedParentLocation = this.ensureTrailingSlash(potentialParent.location);
        return slashTerminatedLocation.startsWith(slashTerminatedParentLocation);
    }
}

