/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.storage.AccessConfig;
import org.immutables.value.Generated;

@Generated(from="AccessConfig", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAccessConfig
implements AccessConfig {
    private final ImmutableMap<String, String> credentials;
    private final ImmutableMap<String, String> extraProperties;
    private transient int hashCode;

    private ImmutableAccessConfig(ImmutableMap<String, String> credentials, ImmutableMap<String, String> extraProperties) {
        this.credentials = credentials;
        this.extraProperties = extraProperties;
    }

    public ImmutableMap<String, String> credentials() {
        return this.credentials;
    }

    public ImmutableMap<String, String> extraProperties() {
        return this.extraProperties;
    }

    public final ImmutableAccessConfig withCredentials(Map<String, ? extends String> entries) {
        if (this.credentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAccessConfig((ImmutableMap<String, String>)newValue, this.extraProperties);
    }

    public final ImmutableAccessConfig withExtraProperties(Map<String, ? extends String> entries) {
        if (this.extraProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAccessConfig(this.credentials, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessConfig && this.equalTo(0, (ImmutableAccessConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.credentials.equals(another.credentials) && this.extraProperties.equals(another.extraProperties);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.extraProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccessConfig").omitNullValues().add("credentials", this.credentials).add("extraProperties", this.extraProperties).toString();
    }

    public static ImmutableAccessConfig copyOf(AccessConfig instance) {
        if (instance instanceof ImmutableAccessConfig) {
            return (ImmutableAccessConfig)instance;
        }
        return ImmutableAccessConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAccessConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessConfig", generator="Immutables")
    public static final class Builder {
        private ImmutableMap.Builder<String, String> credentials = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> extraProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.credentials());
            this.putAllExtraProperties(instance.extraProperties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCredential(String key, String value) {
            this.credentials.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCredential(Map.Entry<String, ? extends String> entry) {
            this.credentials.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Map<String, ? extends String> entries) {
            this.credentials = ImmutableMap.builder();
            return this.putAllCredentials(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCredentials(Map<String, ? extends String> entries) {
            this.credentials.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraProperty(String key, String value) {
            this.extraProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraProperty(Map.Entry<String, ? extends String> entry) {
            this.extraProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extraProperties(Map<String, ? extends String> entries) {
            this.extraProperties = ImmutableMap.builder();
            return this.putAllExtraProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraProperties(Map<String, ? extends String> entries) {
            this.extraProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.credentials = ImmutableMap.builder();
            this.extraProperties = ImmutableMap.builder();
            return this;
        }

        public ImmutableAccessConfig build() {
            return new ImmutableAccessConfig((ImmutableMap<String, String>)this.credentials.build(), (ImmutableMap<String, String>)this.extraProperties.build());
        }
    }
}

