/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="Updates to apply to a Catalog. Any fields which are required in the Catalog will remain unaltered if omitted from the contents of this Update request.")
public class UpdateCatalogRequest {
    private final Integer currentEntityVersion;
    private final Map<String, String> properties;
    @Valid
    private final StorageConfigInfo storageConfigInfo;

    @ApiModelProperty(value="The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.")
    @JsonProperty(value="currentEntityVersion")
    public Integer getCurrentEntityVersion() {
        return this.currentEntityVersion;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="storageConfigInfo")
    public StorageConfigInfo getStorageConfigInfo() {
        return this.storageConfigInfo;
    }

    @JsonCreator
    public UpdateCatalogRequest(@JsonProperty(value="currentEntityVersion") Integer currentEntityVersion, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="storageConfigInfo") StorageConfigInfo storageConfigInfo) {
        this.currentEntityVersion = currentEntityVersion;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
        this.storageConfigInfo = storageConfigInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCatalogRequest updateCatalogRequest = (UpdateCatalogRequest)o;
        return Objects.equals(this.currentEntityVersion, updateCatalogRequest.currentEntityVersion) && Objects.equals(this.properties, updateCatalogRequest.properties) && Objects.equals(this.storageConfigInfo, updateCatalogRequest.storageConfigInfo);
    }

    public int hashCode() {
        return Objects.hash(this.currentEntityVersion, this.properties, this.storageConfigInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCatalogRequest {\n");
        sb.append("    currentEntityVersion: ").append(this.toIndentedString(this.currentEntityVersion)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    storageConfigInfo: ").append(this.toIndentedString(this.storageConfigInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Integer currentEntityVersion;
        private Map<String, String> properties;
        private StorageConfigInfo storageConfigInfo;

        private Builder() {
        }

        public Builder setCurrentEntityVersion(Integer currentEntityVersion) {
            this.currentEntityVersion = currentEntityVersion;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
            this.storageConfigInfo = storageConfigInfo;
            return this;
        }

        public UpdateCatalogRequest build() {
            UpdateCatalogRequest inst = new UpdateCatalogRequest(this.currentEntityVersion, this.properties, this.storageConfigInfo);
            return inst;
        }
    }
}

