/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.StructLikeUtil;

abstract class FanoutWriter<T, R>
implements PartitioningWriter<T, R> {
    private final Map<Integer, StructLikeMap<FileWriter<T, R>>> writers = Maps.newHashMap();
    private boolean closed = false;

    FanoutWriter() {
    }

    protected abstract FileWriter<T, R> newWriter(PartitionSpec var1, StructLike var2);

    protected abstract void addResult(R var1);

    protected abstract R aggregatedResult();

    @Override
    public void write(T row, PartitionSpec spec, StructLike partition) {
        FileWriter<T, R> writer = this.writer(spec, partition);
        writer.write(row);
    }

    private FileWriter<T, R> writer(PartitionSpec spec, StructLike partition) {
        Map specWriters = this.writers.computeIfAbsent(spec.specId(), id -> StructLikeMap.create(spec.partitionType()));
        FileWriter<T, R> writer = (FileWriter<T, R>)specWriters.get(partition);
        if (writer == null) {
            StructLike copiedPartition = StructLikeUtil.copy(partition);
            writer = this.newWriter(spec, copiedPartition);
            specWriters.put(copiedPartition, writer);
        }
        return writer;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeWriters();
            this.closed = true;
        }
    }

    private void closeWriters() throws IOException {
        for (Map map : this.writers.values()) {
            for (FileWriter writer : map.values()) {
                writer.close();
                this.addResult(writer.result());
            }
            map.clear();
        }
        this.writers.clear();
    }

    @Override
    public final R result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot get result from unclosed writer");
        return this.aggregatedResult();
    }
}

