/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.external;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.polaris.service.quarkus.auth.QuarkusPrincipalAuthInfo;
import org.apache.polaris.service.quarkus.auth.external.OidcTenantConfiguration;
import org.apache.polaris.service.quarkus.auth.external.OidcTenantResolvingAugmentor;
import org.apache.polaris.service.quarkus.auth.external.mapping.PrincipalMapper;
import org.apache.polaris.service.quarkus.auth.external.mapping.PrincipalRolesMapper;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class PrincipalAuthInfoAugmentor
implements SecurityIdentityAugmentor {
    public static final int PRIORITY = 1100;
    private final Instance<PrincipalMapper> principalMappers;
    private final Instance<PrincipalRolesMapper> principalRoleMappers;

    @Inject
    public PrincipalAuthInfoAugmentor(@Any Instance<PrincipalMapper> principalMappers, @Any Instance<PrincipalRolesMapper> principalRoleMappers) {
        this.principalMappers = principalMappers;
        this.principalRoleMappers = principalRoleMappers;
    }

    public int priority() {
        return 1100;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous() || !(identity.getPrincipal() instanceof JsonWebToken)) {
            return Uni.createFrom().item((Object)identity);
        }
        OidcTenantConfiguration config = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity);
        PrincipalMapper principalMapper = (PrincipalMapper)this.principalMappers.select(new Annotation[]{Identifier.Literal.of((String)config.principalMapper().type())}).get();
        PrincipalRolesMapper principalRolesMapper = (PrincipalRolesMapper)this.principalRoleMappers.select(new Annotation[]{Identifier.Literal.of((String)config.principalRolesMapper().type())}).get();
        return Uni.createFrom().item(() -> this.setPrincipalAuthInfo(identity, principalMapper, principalRolesMapper));
    }

    protected SecurityIdentity setPrincipalAuthInfo(SecurityIdentity identity, PrincipalMapper principalMapper, PrincipalRolesMapper rolesMapper) {
        Long principalId = principalMapper.mapPrincipalId(identity).stream().boxed().findFirst().orElse(null);
        String principalName = principalMapper.mapPrincipalName(identity).orElse(null);
        Set<String> principalRoles = rolesMapper.mapPrincipalRoles(identity);
        OidcPrincipalAuthInfo credential = new OidcPrincipalAuthInfo(principalId, principalName, principalRoles);
        return QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addCredential((Credential)credential).build();
    }

    protected record OidcPrincipalAuthInfo(@Nullable Long getPrincipalId, @Nullable String getPrincipalName, Set<String> getPrincipalRoles) implements QuarkusPrincipalAuthInfo
    {
    }
}

