/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.raft.jraft.util.Recyclable;
import org.apache.ignite.raft.jraft.util.Recyclers;

public final class RecyclableByteBufferList
extends ArrayList<ByteBuffer>
implements Recyclable {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int capacity = 0;
    private final transient Recyclers.Handle handle;
    private static final Recyclers<RecyclableByteBufferList> recyclers = new Recyclers<RecyclableByteBufferList>(512){

        @Override
        protected RecyclableByteBufferList newObject(Recyclers.Handle handle) {
            return new RecyclableByteBufferList(handle);
        }
    };

    public static RecyclableByteBufferList newInstance() {
        return RecyclableByteBufferList.newInstance(8);
    }

    public static RecyclableByteBufferList newInstance(int minCapacity) {
        RecyclableByteBufferList ret = recyclers.get();
        ret.ensureCapacity(minCapacity);
        return ret;
    }

    public static ByteBuffer concatenate(List<ByteBuffer> buffers) {
        ByteBuffer combined = ByteBuffer.allocate(buffers.stream().mapToInt(Buffer::remaining).sum());
        buffers.stream().forEach((? super T b) -> combined.put(b.duplicate()));
        return combined;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean addAll(Collection<? extends ByteBuffer> c) {
        throw RecyclableByteBufferList.reject("addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends ByteBuffer> c) {
        throw RecyclableByteBufferList.reject("addAll");
    }

    @Override
    public boolean add(ByteBuffer element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.capacity += element.remaining();
        return super.add(element);
    }

    @Override
    public void add(int index, ByteBuffer element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.capacity += element.remaining();
        super.add(index, element);
    }

    @Override
    public ByteBuffer set(int index, ByteBuffer element) {
        throw RecyclableByteBufferList.reject("set");
    }

    @Override
    public ByteBuffer remove(int index) {
        throw RecyclableByteBufferList.reject("remove");
    }

    @Override
    public boolean remove(Object o) {
        throw RecyclableByteBufferList.reject("remove");
    }

    @Override
    public boolean recycle() {
        this.clear();
        this.capacity = 0;
        return recyclers.recycle(this, this.handle);
    }

    public static int threadLocalCapacity() {
        return recyclers.threadLocalCapacity();
    }

    public static int threadLocalSize() {
        return recyclers.threadLocalSize();
    }

    private static UnsupportedOperationException reject(String message) {
        return new UnsupportedOperationException(message);
    }

    private RecyclableByteBufferList(Recyclers.Handle handle) {
        this(handle, 8);
    }

    private RecyclableByteBufferList(Recyclers.Handle handle, int initialCapacity) {
        super(initialCapacity);
        this.handle = handle;
    }
}

